% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_synth_data.R
\name{pull_synth_data}
\alias{pull_synth_data}
\title{Pull ACS data for synthetic data creation.}
\usage{
pull_synth_data(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a list of \code{data.frame}s of estimates,
a list of \code{data.frame}s of standard errors, 
and the geography metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B01001, B02001, B12002, B15001, B06001, B06010, B23001, B17005, and B17005.
These tables reference population counts by a number of slices.
Multiple additional fields, mainly percentages and aggregations, are calculated.
}
\examples{
\dontrun{
# make geography
la_geo <- acs::geo.make(state= "CA", county= "Los Angeles", tract= "*")
# pull data elements for creating synthetic data
la_dat <- pull_synth_data(2014, 5, la_geo)
}
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}
