% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_nc.R
\name{tidy_nc}
\alias{tidy_nc}
\title{Set the time period and the geogprahical extension, as well as computes the anomaly of the atmospheric variable/s}
\usage{
tidy_nc(x, time_subset = NULL, geo_subset = NULL,
  monthly_subset = NULL, name_vars = NULL)
}
\arguments{
\item{x}{data.frame. A data.frame with the following variables: \code{lon, lat, time, value}. The same structure returned when using \code{download_ncep}.}

\item{time_subset}{vector. Starting and ending date, or a vector of dates of interest.}

\item{geo_subset}{vector. A vector providing the \code{xmin,xmax,ymin,ymax}.}

\item{monthly_subset}{an integer or a vector of integers. Number of the month/s desired.}

\item{name_vars}{character or a vector of characters. Name of the atmospheric variable/s. If name is not specified, then will be coded as integers.}
}
\value{
A data.frame with the following variables: \code{lon, lat, time, value, anom_value}
}
\description{
This function allows to subset the time series and geogprahical area of your atmospheric variable.
In addition, even if no argument is given, the anomaly of the atmospheric variable/s will be computed.
The anomaly value is provided in order to facilitate the visualization of the results after use the \code{synoptclas} function.
It is mandatory to pass the \code{tidy_nc} even if you do not want to change the time period or the geographical extension.
}
\examples{
# Load data (mslp or precp_grid)
data(mslp)
data(z500)
# Tidying our atmospheric variables (500 hPa geopotential height
# and mean sea level pressure) together.

# Time subset between two dates
atm_data1 <- tidy_nc(x = list(mslp,z500), time_subset = c("2000-05-01","2001-04-30"))

# Time subset using a vector of dates of interest. Including a geographical crop
dates_int <- c("2000-01-25","2000-04-01","2000-07-14","2001-05-08","2002-12-20")
atm_data1 <- tidy_nc(x = list(mslp,z500),
                     time_subset = dates_int,
                     geo_subset = c(-20,10,30,50),
                     name_vars = c("mslp","z500")) # following the list sequence

}
\seealso{
\code{\link{download_ncep}}
}
