/*
 * Decompiled with CFR 0.152.
 */
package dag;

import blbutil.Const;
import blbutil.IntSet;
import dag.DagLevel;
import java.util.Arrays;

public final class HighCapacityDagLevel
implements DagLevel {
    private final float count;
    private final int[] parentNodes;
    private final int[] childNodes;
    private final int[] parentIndices;
    private final int[] parents;
    private final int[] childIndices;
    private final int[] children;
    private final int[] symbols;
    private final float[] edgeCounts;
    private final float[] condEdgeProbs;
    private final float[] parentCounts;

    public HighCapacityDagLevel(int[] nArray, int[] nArray2, int[] nArray3, float[] fArray) {
        int n = HighCapacityDagLevel.checkLengths(nArray, nArray2, nArray3, fArray);
        this.parentIndices = HighCapacityDagLevel.getIndicesArray(nArray);
        this.childIndices = HighCapacityDagLevel.getIndicesArray(nArray2);
        this.parentNodes = (int[])nArray.clone();
        this.childNodes = (int[])nArray2.clone();
        this.symbols = (int[])nArray3.clone();
        this.edgeCounts = (float[])fArray.clone();
        this.condEdgeProbs = new float[n];
        this.parents = new int[n];
        this.children = new int[n];
        int[] nArray4 = Arrays.copyOfRange(this.parentIndices, 0, this.parentIndices.length - 1);
        int[] nArray5 = Arrays.copyOfRange(this.childIndices, 0, this.childIndices.length - 1);
        this.parentCounts = this.parentCnts(nArray, fArray, nArray4.length);
        this.count = this.sum(this.parentCounts);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            int n4 = n2;
            int n5 = nArray4[n4];
            nArray4[n4] = n5 + 1;
            this.parents[n5] = i;
            int n6 = n3;
            int n7 = nArray5[n6];
            nArray5[n6] = n7 + 1;
            this.children[n7] = i;
            this.condEdgeProbs[i] = fArray[i] / this.parentCounts[n2];
        }
        HighCapacityDagLevel.checkForDuplicateOutEdges(this.parentIndices, this.parents, nArray3);
    }

    private static int checkLengths(int[] nArray, int[] nArray2, int[] nArray3, float[] fArray) {
        if (nArray.length != nArray2.length || nArray.length != nArray3.length || nArray.length != fArray.length) {
            throw new IllegalArgumentException("inconsistent arrays");
        }
        return nArray.length;
    }

    private static void checkForDuplicateOutEdges(int[] nArray, int[] nArray2, int[] nArray3) {
        IntSet intSet = new IntSet(nArray3.length);
        for (int i = 1; i < nArray.length; ++i) {
            intSet.clear();
            int n = nArray[i];
            for (int j = nArray[i - 1]; j < n; ++j) {
                int n2 = nArray2[j];
                if (intSet.add(nArray3[n2])) continue;
                throw new IllegalArgumentException("duplicate edge");
            }
        }
    }

    private static int[] getIndicesArray(int[] nArray) {
        int[] nArray2 = HighCapacityDagLevel.elementCounts(nArray);
        int[] nArray3 = new int[nArray2.length + 1];
        for (int i = 1; i < nArray3.length; ++i) {
            assert (nArray2[i - 1] > 0);
            nArray3[i] = nArray3[i - 1] + nArray2[i - 1];
        }
        return nArray3;
    }

    private static int[] elementCounts(int[] nArray) {
        int n = HighCapacityDagLevel.max(nArray);
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = nArray;
        int n2 = nArray3.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = n3 = nArray3[i];
            nArray2[n4] = nArray2[n4] + 1;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] != 0) continue;
            throw new IllegalArgumentException("no element with value " + i);
        }
        return nArray2;
    }

    private static int max(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private float sum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return f;
    }

    private float[] parentCnts(int[] nArray, float[] fArray, int n) {
        float[] fArray2 = new float[n];
        for (int i = 0; i < this.condEdgeProbs.length; ++i) {
            int n2;
            int n3 = n2 = nArray[i];
            fArray2[n3] = fArray2[n3] + fArray[i];
        }
        return fArray2;
    }

    @Override
    public int nEdges() {
        return this.condEdgeProbs.length;
    }

    @Override
    public int nParentNodes() {
        return this.parentIndices.length - 1;
    }

    @Override
    public int nChildNodes() {
        return this.childIndices.length - 1;
    }

    @Override
    public int parentNode(int n) {
        return this.parentNodes[n];
    }

    @Override
    public int childNode(int n) {
        return this.childNodes[n];
    }

    @Override
    public int symbol(int n) {
        return this.symbols[n];
    }

    @Override
    public float edgeWeight(int n) {
        return this.edgeCounts[n];
    }

    @Override
    public float parentWeight(int n) {
        return this.parentCounts[n];
    }

    @Override
    public float condEdgeProb(int n) {
        return this.condEdgeProbs[n];
    }

    @Override
    public float edgeProb(int n) {
        return this.edgeCounts[n] / this.count;
    }

    @Override
    public float parentProb(int n) {
        return this.parentCounts[n] / this.count;
    }

    @Override
    public int nOutEdges(int n) {
        return this.parentIndices[n + 1] - this.parentIndices[n];
    }

    @Override
    public int outEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.nOutEdges(n)) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.parents[this.parentIndices[n] + n2];
    }

    @Override
    public int outEdgeBySymbol(int n, int n2) {
        int n3 = this.parentIndices[n];
        int n4 = this.parentIndices[n + 1];
        for (int i = n3; i < n4; ++i) {
            int n5 = this.parents[i];
            if (this.symbols[n5] != n2) continue;
            return n5;
        }
        return -1;
    }

    @Override
    public int nInEdges(int n) {
        return this.childIndices[n + 1] - this.childIndices[n];
    }

    @Override
    public int inEdge(int n, int n2) {
        if (n2 < 0 || n2 >= this.nInEdges(n)) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.children[this.childIndices[n] + n2];
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentNodes=");
        stringBuilder.append(Arrays.toString(this.parentNodes));
        stringBuilder.append(Const.nl);
        stringBuilder.append("childNodes=");
        stringBuilder.append(Arrays.toString(this.childNodes));
        stringBuilder.append(Const.nl);
        stringBuilder.append("symbols=");
        stringBuilder.append(Arrays.toString(this.symbols));
        stringBuilder.append(Const.nl);
        stringBuilder.append("condEdgeProbs=");
        stringBuilder.append(Arrays.toString(this.condEdgeProbs));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentCounts=");
        stringBuilder.append(Arrays.toString(this.parentCounts));
        stringBuilder.append(Const.nl);
        stringBuilder.append("edgeCounts=");
        stringBuilder.append(Arrays.toString(this.edgeCounts));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parentIndices=");
        stringBuilder.append(Arrays.toString(this.parentIndices));
        stringBuilder.append(Const.nl);
        stringBuilder.append("parents=");
        stringBuilder.append(Arrays.toString(this.parents));
        stringBuilder.append(Const.nl);
        stringBuilder.append("childIndices=");
        stringBuilder.append(Arrays.toString(this.childIndices));
        stringBuilder.append(Const.nl);
        stringBuilder.append("children=");
        stringBuilder.append(Arrays.toString(this.children));
        return stringBuilder.toString();
    }
}

