/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Const;
import blbutil.FileIterator;
import blbutil.Filter;
import blbutil.FilterUtils;
import blbutil.InputIterator;
import blbutil.SampleFileIterator;
import java.io.File;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import vcf.FilteredVcfIterator;
import vcf.IntervalVcfIterator;
import vcf.Marker;
import vcf.VcfHeader;
import vcf.VcfRecord;

public class VcfIterator
implements SampleFileIterator<VcfRecord> {
    private static final Filter<String> ACCEPT_ALL_FILTER = FilterUtils.acceptAllFilter();
    private final VcfHeader vcfHeader;
    private final FileIterator<String> it;
    private final Set<String> chromSet = new HashSet<String>();
    private VcfRecord current;
    private VcfRecord next;

    public static SampleFileIterator<VcfRecord> filteredIterator(File file, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval) {
        SampleFileIterator<VcfRecord> sampleFileIterator = new VcfIterator(file, filter);
        if (chromInterval != null) {
            sampleFileIterator = new IntervalVcfIterator(sampleFileIterator, chromInterval);
        }
        if (filter2 != null) {
            sampleFileIterator = new FilteredVcfIterator(sampleFileIterator, filter2);
        }
        return sampleFileIterator;
    }

    public VcfIterator(File file) {
        this(file, ACCEPT_ALL_FILTER);
    }

    public VcfIterator(File file, Filter<String> filter) {
        this(InputIterator.fromGzipFile(file), filter);
    }

    public VcfIterator(FileIterator<String> fileIterator) {
        this(fileIterator, ACCEPT_ALL_FILTER);
    }

    private VcfIterator(FileIterator<String> fileIterator, Filter<String> filter) {
        if (filter == null) {
            filter = ACCEPT_ALL_FILTER;
        }
        this.it = fileIterator;
        this.vcfHeader = new VcfHeader(fileIterator, filter);
        this.current = null;
        this.next = this.readData();
    }

    public static VcfIterator fromStdin() {
        InputIterator inputIterator = new InputIterator(System.in);
        return new VcfIterator(inputIterator, ACCEPT_ALL_FILTER);
    }

    public static VcfIterator fromStdin(Filter<String> filter) {
        InputIterator inputIterator = new InputIterator(System.in);
        return new VcfIterator(inputIterator, filter);
    }

    @Override
    public void close() {
        this.it.close();
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public VcfRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = this.readData();
        this.checkMarkerPosOrder(this.current, this.next);
        return this.current;
    }

    @Override
    public void remove() {
        String string = "remove() is not supported by VcfIterator";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public Samples samples() {
        return this.vcfHeader.samples();
    }

    private VcfRecord readData() {
        VcfRecord vcfRecord = null;
        while (this.it.hasNext() && vcfRecord == null) {
            String string = ((String)this.it.next()).trim();
            if (string.isEmpty()) continue;
            vcfRecord = new VcfRecord(string, this.vcfHeader);
        }
        return vcfRecord;
    }

    private void checkMarkerPosOrder(VcfRecord vcfRecord, VcfRecord vcfRecord2) {
        if (vcfRecord2 != null) {
            Marker marker = vcfRecord.marker();
            Marker marker2 = vcfRecord2.marker();
            if (marker.chromIndex() == marker2.chromIndex()) {
                if (marker.pos() > marker2.pos()) {
                    String string = "[" + (this.it.file() == null ? "stdin" : this.it.file().toString()) + "] markers not in chromosomal order: " + Const.nl + marker + Const.nl + marker2;
                    throw new IllegalArgumentException(string);
                }
            } else {
                boolean bl = this.chromSet.add(marker2.chrom());
                if (!bl) {
                    String string = "[" + (this.it.file() == null ? "stdin" : this.it.file().toString()) + "] non-contiguous markers for chromosome " + marker2.chrom();
                    throw new IllegalArgumentException(string);
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("file=");
        stringBuilder.append(this.it.file());
        stringBuilder.append(" next=");
        stringBuilder.append(this.next);
        return stringBuilder.toString();
    }
}

