/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.SampleIds;
import blbutil.Const;
import blbutil.FileUtil;
import haplotype.BasicSampleHapPairs;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import java.io.File;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import main.GenotypeValues;
import main.GprobsStatistics;
import vcf.Marker;
import vcf.Markers;

public final class VcfWriter {
    private static final String PASS = "PASS";
    private static final DecimalFormat df3 = new DecimalFormat("#.###");
    private static final String fileformat = "##fileformat=VCFv4.1";
    private static final String afInfo = "##INFO=<ID=AF,Number=A,Type=Float,Description=\"Estimated Allele Frequencies\">";
    private static final String ar2Info = "##INFO=<ID=AR2,Number=1,Type=Float,Description=\"Allelic R-Squared: estimated correlation between most probable ALT dose and true ALT dose\">";
    private static final String dr2Info = "##INFO=<ID=DR2,Number=1,Type=Float,Description=\"Dosage R-Squared: estimated correlation between estimated ALT dose [P(RA) + 2*P(AA)] and true ALT dose\">";
    private static final String gtFormat = "##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
    private static final String dsFormat = "##FORMAT=<ID=DS,Number=1,Type=Float,Description=\"estimated ALT dose [P(RA) + P(AA)]\">";
    private static final String glFormat = "##FORMAT=<ID=GL,Number=G,Type=Float,Description=\"Log10-scaled Genotype Likelihood\">";
    private static final String gpFormat = "##FORMAT=<ID=GP,Number=G,Type=Float,Description=\"Estimated Genotype Probability\">";
    private static final String shortChromPrefix = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO";
    private static final String longChromPrefix = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";

    private VcfWriter() {
    }

    public static void write(String string, SampleHapPairs sampleHapPairs, File file) {
        try (PrintWriter printWriter = FileUtil.bgzipPrintWriter(file);){
            VcfWriter.writeMetaLinesGT(sampleHapPairs.samples().ids(), string, printWriter);
            VcfWriter.appendRecords(sampleHapPairs, 0, sampleHapPairs.nMarkers(), printWriter);
        }
    }

    public static void write(String string, List<HapPair> list, File file) {
        try (PrintWriter printWriter = FileUtil.bgzipPrintWriter(file);){
            String[] stringArray = VcfWriter.sampleIds(list);
            Markers markers = BasicSampleHapPairs.checkAndExtractMarkers(list);
            VcfWriter.writeMetaLinesGT(stringArray, string, printWriter);
            for (int i = 0; i < markers.nMarkers(); ++i) {
                VcfWriter.printFixedFieldsGT(markers.marker(i), printWriter);
                for (int j = 0; j < stringArray.length; ++j) {
                    printWriter.print('\t');
                    printWriter.print(list.get(j).allele1(i));
                    printWriter.print('|');
                    printWriter.print(list.get(j).allele2(i));
                }
                printWriter.println();
            }
        }
    }

    private static String[] sampleIds(List<HapPair> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = SampleIds.instance().id(list.get(i).idIndex());
        }
        return stringArray;
    }

    public static void writeMetaLinesGT(String[] stringArray, String string, PrintWriter printWriter) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        VcfWriter.writeMetaLines(stringArray, string, bl, bl2, bl3, printWriter);
    }

    public static void writeMetaLines(String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, PrintWriter printWriter) {
        printWriter.print(fileformat);
        printWriter.print(Const.nl);
        printWriter.print("##filedate=");
        printWriter.print(VcfWriter.now());
        printWriter.print(Const.nl);
        if (string != null) {
            printWriter.print("##source=\"");
            printWriter.print(string);
            printWriter.println("\"");
        }
        if (bl2) {
            printWriter.println(afInfo);
            printWriter.println(ar2Info);
            printWriter.println(dr2Info);
        }
        if (bl) {
            printWriter.println(gtFormat);
        }
        if (bl3) {
            printWriter.println(glFormat);
        }
        if (bl2) {
            printWriter.println(dsFormat);
            printWriter.println(gpFormat);
        }
        printWriter.print(longChromPrefix);
        for (String string2 : stringArray) {
            if (string2 == null) {
                throw new NullPointerException("id==null");
            }
            printWriter.print('\t');
            printWriter.print(string2);
        }
        printWriter.println();
    }

    private static String now() {
        String string = "yyyyMMdd";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static void appendRecords(SampleHapPairs sampleHapPairs, GenotypeValues genotypeValues, int n, int n2, PrintWriter printWriter) {
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        if (!sampleHapPairs.markers().equals(genotypeValues.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        float[] fArray = new float[2];
        for (int i = n; i < n2; ++i) {
            VcfWriter.printFixedFields(genotypeValues, i, printWriter);
            int n3 = sampleHapPairs.nSamples();
            for (int j = 0; j < n3; ++j) {
                printWriter.print('\t');
                printWriter.print(sampleHapPairs.allele1(i, j));
                printWriter.print('|');
                printWriter.print(sampleHapPairs.allele2(i, j));
                int n4 = sampleHapPairs.idIndex(j);
                int n5 = genotypeValues.samples().index(n4);
                if (n5 < 0) {
                    throw new IllegalArgumentException("inconsistent samples");
                }
                int n6 = genotypeValues.marker(i).nGenotypes();
                VcfWriter.sumAndAltDose(genotypeValues, i, n5, fArray);
                float f = fArray[0];
                float f2 = fArray[1];
                if (f == 0.0f) {
                    printWriter.print(':');
                    printWriter.print('.');
                    printWriter.print(':');
                    printWriter.print('.');
                    continue;
                }
                printWriter.print(':');
                printWriter.print(df3.format(f2 / f));
                for (int k = 0; k < n6; ++k) {
                    printWriter.print(k == 0 ? (char)':' : ',');
                    double d = genotypeValues.value(i, n5, k) / f;
                    printWriter.print(df3.format(d));
                }
            }
            printWriter.println();
        }
    }

    public static void appendRecords(SampleHapPairs sampleHapPairs, int n, int n2, PrintWriter printWriter) {
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        for (int i = n; i < n2; ++i) {
            VcfWriter.printFixedFieldsGT(sampleHapPairs.marker(i), printWriter);
            int n3 = sampleHapPairs.nSamples();
            for (int j = 0; j < n3; ++j) {
                printWriter.print('\t');
                printWriter.print(sampleHapPairs.allele1(i, j));
                printWriter.print('|');
                printWriter.print(sampleHapPairs.allele2(i, j));
            }
            printWriter.println();
        }
    }

    private static void sumAndAltDose(GenotypeValues genotypeValues, int n, int n2, float[] fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n3 = genotypeValues.marker(n).nAlleles();
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < i; ++j) {
                float f3 = genotypeValues.value(n, n2, n4++);
                f += f3;
                f2 += j == 0 ? f3 : 2.0f * f3;
            }
            float f4 = genotypeValues.value(n, n2, n4++);
            f += f4;
            f2 = (float)((double)f2 + (i == 0 ? 0.0 : (double)(2.0f * f4)));
        }
        assert (n4 == genotypeValues.marker(n).nGenotypes());
        fArray[0] = f;
        fArray[1] = f2;
    }

    public static void printFixedFieldsGT(Marker marker, PrintWriter printWriter) {
        printWriter.print(marker);
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print(PASS);
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("GT");
    }

    private static void printFixedFields(GenotypeValues genotypeValues, int n, PrintWriter printWriter) {
        GprobsStatistics gprobsStatistics = new GprobsStatistics(genotypeValues, n);
        float[] fArray = gprobsStatistics.alleleFreq();
        printWriter.print(genotypeValues.marker(n));
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print(PASS);
        printWriter.print('\t');
        printWriter.print("AR2=");
        printWriter.print(df3.format(gprobsStatistics.allelicR2()));
        printWriter.print(";DR2=");
        printWriter.print(df3.format(gprobsStatistics.doseR2()));
        for (int i = 1; i < fArray.length; ++i) {
            printWriter.print(i == 1 ? ";AF=" : Character.valueOf(','));
            printWriter.print(df3.format(fArray[i]));
        }
        printWriter.print('\t');
        printWriter.print("GT:DS:GP");
    }
}

