/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.StringUtil;
import java.text.DecimalFormat;
import java.util.Arrays;
import main.NuclearFamilies;
import vcf.BasicGL;
import vcf.Marker;
import vcf.VcfEmission;
import vcf.VcfRecord;

public final class MedMemGL
implements VcfEmission {
    public static final String GL_FORMAT = "GL";
    public static final String PL_FORMAT = "PL";
    static final DecimalFormat df = new DecimalFormat("#.####");
    private static final float MIN_LIKE = 1.435E-42f;
    private final Marker marker;
    private final Samples samples;
    private final float[] like;

    public MedMemGL(VcfRecord vcfRecord, NuclearFamilies nuclearFamilies, float f) {
        if (vcfRecord.nSamples() == 0) {
            String string = "missing sample data: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        if (!vcfRecord.samples().equals(nuclearFamilies.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (Float.isNaN(f) || f <= 1.0f) {
            throw new IllegalArgumentException("maxLR: " + f);
        }
        if (!vcfRecord.hasFormat(GL_FORMAT) && !vcfRecord.hasFormat(PL_FORMAT)) {
            String string = "missing GL/PL format: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        float f2 = 1.0f / f;
        this.samples = vcfRecord.samples();
        this.marker = vcfRecord.marker();
        this.like = MedMemGL.likelihoods(vcfRecord, nuclearFamilies, f2);
    }

    private static float[] likelihoods(VcfRecord vcfRecord, NuclearFamilies nuclearFamilies, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Marker marker = vcfRecord.marker();
        int n7 = marker.nGenotypes();
        boolean[] blArray = new boolean[vcfRecord.marker().nAlleles()];
        boolean[] blArray2 = new boolean[vcfRecord.marker().nAlleles()];
        float[] fArray = MedMemGL.likelihoodsFromGL(vcfRecord);
        float[] fArray2 = MedMemGL.copyAndApplyMinLR(fArray, f);
        int n8 = nuclearFamilies.nDuos();
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = nuclearFamilies.duoParent(n6);
            if (MedMemGL.duoIsConsistent(marker, fArray, f, n5, n4 = nuclearFamilies.duoOffspring(n6), blArray, blArray2)) continue;
            n3 = n5 * n7;
            n2 = n4 * n7;
            for (n = 0; n < n7; ++n) {
                fArray2[n3 + n] = Math.max(1.435E-42f, fArray[n3 + n]);
                fArray2[n2 + n] = Math.max(1.435E-42f, fArray[n2 + n]);
            }
        }
        n8 = nuclearFamilies.nTrios();
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = nuclearFamilies.trioFather(n6);
            if (MedMemGL.trioIsConsistent(marker, fArray, f, n5, n4 = nuclearFamilies.trioMother(n6), n3 = nuclearFamilies.trioOffspring(n6), blArray, blArray2)) continue;
            n2 = n5 * n7;
            n = n4 * n7;
            int n9 = n3 * n7;
            for (int i = 0; i < n7; ++i) {
                fArray2[n2 + i] = Math.max(1.435E-42f, fArray[n2 + i]);
                fArray2[n + i] = Math.max(1.435E-42f, fArray[n + i]);
                fArray2[n9 + i] = Math.max(1.435E-42f, fArray[n9 + i]);
            }
        }
        return fArray2;
    }

    private static float[] likelihoodsFromGL(VcfRecord vcfRecord) {
        int n = vcfRecord.marker().nGenotypes();
        String[] stringArray = vcfRecord.hasFormat(GL_FORMAT) ? vcfRecord.formatData(GL_FORMAT) : null;
        String[] stringArray2 = vcfRecord.hasFormat(PL_FORMAT) ? vcfRecord.formatData(PL_FORMAT) : null;
        double[] dArray = new double[n];
        float[] fArray = new float[vcfRecord.nSamples() * n];
        int n2 = 0;
        int n3 = vcfRecord.nSamples();
        for (int i = 0; i < n3; ++i) {
            int n4;
            Arrays.fill(dArray, 0.0);
            if (stringArray != null) {
                String[] stringArray3 = MedMemGL.getGL(GL_FORMAT, stringArray, i, n, vcfRecord);
                for (n4 = 0; n4 < n; ++n4) {
                    dArray[n4] = MedMemGL.GL2Like(stringArray3[n4]);
                }
            } else if (stringArray2 != null) {
                String[] stringArray4 = MedMemGL.getGL(PL_FORMAT, stringArray2, i, n, vcfRecord);
                for (n4 = 0; n4 < n; ++n4) {
                    dArray[n4] = MedMemGL.PL2Like(stringArray4[n4]);
                }
            }
            MedMemGL.rescaleToMax1(dArray);
            for (int j = 0; j < n; ++j) {
                fArray[n2++] = (float)dArray[j];
            }
        }
        assert (n2 == fArray.length);
        return fArray;
    }

    private static boolean duoIsConsistent(Marker marker, float[] fArray, float f, int n, int n2, boolean[] blArray, boolean[] blArray2) {
        MedMemGL.alleles(marker, fArray, f, n, blArray);
        MedMemGL.alleles(marker, fArray, f, n2, blArray2);
        int n3 = marker.nAlleles();
        for (int i = 0; i < n3; ++i) {
            if (!blArray[i] || !blArray2[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean trioIsConsistent(Marker marker, float[] fArray, float f, int n, int n2, int n3, boolean[] blArray, boolean[] blArray2) {
        byte by = marker.nAlleles();
        MedMemGL.alleles(marker, fArray, f, n, blArray);
        MedMemGL.alleles(marker, fArray, f, n2, blArray2);
        int n4 = n3 * marker.nGenotypes();
        for (byte by2 = 0; by2 < by; by2 = (byte)((byte)(by2 + 1))) {
            if (!blArray[by2]) continue;
            for (byte by3 = 0; by3 < by; by3 = (byte)(by3 + 1)) {
                int n5;
                if (!blArray2[by3] || !(fArray[n4 + (n5 = BasicGL.genotype(by2, by3))] >= f)) continue;
                return true;
            }
        }
        return false;
    }

    private static void alleles(Marker marker, float[] fArray, float f, int n, boolean[] blArray) {
        Arrays.fill(blArray, false);
        int n2 = n * marker.nGenotypes();
        for (byte by = 0; by < blArray.length; by = (byte)(by + 1)) {
            for (byte by2 = by; by2 < blArray.length; by2 = (byte)(by2 + 1)) {
                int n3 = BasicGL.genotype(by, by2);
                if (!(fArray[n2 + n3] >= f)) continue;
                byte by3 = by;
                blArray[by3] = blArray[by3] | true;
                byte by4 = by2;
                blArray[by4] = blArray[by4] | true;
            }
        }
    }

    private static void rescaleToMax1(double[] dArray) {
        double d = MedMemGL.max(dArray);
        if (d == 0.0) {
            Arrays.fill(dArray, 1.0);
        } else {
            int n = 0;
            while (n < dArray.length) {
                int n2 = n++;
                dArray[n2] = dArray[n2] / d;
            }
        }
    }

    private static double max(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    private static float[] copyAndApplyMinLR(float[] fArray, float f) {
        float[] fArray2 = (float[])fArray.clone();
        for (int i = 0; i < fArray2.length; ++i) {
            if (!(fArray2[i] < f)) continue;
            fArray2[i] = 0.0f;
        }
        return fArray2;
    }

    private static String[] getGL(String string, String[] stringArray, int n, int n2, VcfRecord vcfRecord) {
        if (stringArray[n].equals(".")) {
            Object[] objectArray = new String[n2];
            Arrays.fill(objectArray, "0");
            return objectArray;
        }
        String[] stringArray2 = StringUtil.getFields(stringArray[n], ',');
        if (stringArray2.length != n2) {
            String string2 = "unexpected number of " + string + " subfields: " + vcfRecord.sampleFormatData(string, n) + Const.nl + vcfRecord;
            throw new IllegalArgumentException(string2);
        }
        for (String string3 : stringArray2) {
            if (!string3.equals(".")) continue;
            String string4 = "missing subfield in " + string + " field: " + vcfRecord.sampleFormatData(string, n) + Const.nl + vcfRecord;
            throw new IllegalArgumentException(string4);
        }
        return stringArray2;
    }

    private static double GL2Like(String string) {
        return Math.pow(10.0, Double.parseDouble(string));
    }

    private static double PL2Like(String string) {
        return VcfRecord.fromPhred(Integer.parseInt(string));
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return false;
    }

    @Override
    public boolean isMissingData() {
        return false;
    }

    @Override
    public boolean isPhased(int n) {
        return false;
    }

    @Override
    public byte allele1(int n) {
        return -1;
    }

    @Override
    public byte allele2(int n) {
        return -1;
    }

    @Override
    public float gl(int n, byte by, byte by2) {
        int n2 = this.marker.nAlleles();
        if (by < 0 || by2 < 0 || by >= n2 || by2 >= n2) {
            String string = by + " " + by2 + " " + n2;
            throw new ArrayIndexOutOfBoundsException(string);
        }
        int n3 = VcfRecord.gtIndex(by, by2);
        return this.like[n * this.marker.nGenotypes() + n3];
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.marker);
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append(GL_FORMAT);
        int n = this.samples.nSamples();
        for (int i = 0; i < n; ++i) {
            int n2 = this.marker.nGenotypes();
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(j == 0 ? (char)'\t' : ',');
                double d = Math.log10(this.like[i * this.marker.nGenotypes() + j]);
                stringBuilder.append(df.format(d));
            }
        }
        return stringBuilder.toString();
    }
}

