/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Utilities;
import dag.Dag;
import dag.LinkageEquilibriumDag;
import dag.MergeableDag;
import haplotype.BasicHapPairs;
import haplotype.HapPair;
import haplotype.HapPairs;
import haplotype.RevHapPair;
import haplotype.Weights;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import main.GenotypeValues;
import main.NuclearFamilies;
import main.Parameters;
import main.RevGenotypeValues;
import main.RunStats;
import sample.DuoBaum;
import sample.HapBaum;
import sample.ProduceHapSamples;
import sample.ProduceSingleSamples;
import sample.SingleBaum;
import sample.TrioBaum;
import vcf.AL;
import vcf.GL;
import vcf.Markers;
import vcf.RevAL;
import vcf.RevGL;

public final class HapPairSampler {
    private final Parameters par;
    private final RunStats runStats;

    public HapPairSampler(Parameters parameters, RunStats runStats) {
        if (parameters == null) {
            throw new IllegalArgumentException("par==null");
        }
        if (runStats == null) {
            throw new IllegalArgumentException("runStats==null");
        }
        this.par = parameters;
        this.runStats = runStats;
    }

    public List<HapPair> initialHaps(NuclearFamilies nuclearFamilies, GL gL, GL gL2) {
        if (!gL.markers().equals(gL2.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!nuclearFamilies.samples().equals(gL2.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        boolean bl = false;
        float f = 1.0E-4f;
        LinkageEquilibriumDag linkageEquilibriumDag = new LinkageEquilibriumDag(gL, f);
        ArrayList<HapPair> arrayList = new ArrayList();
        arrayList = Collections.synchronizedList(arrayList);
        this.singleSample(nuclearFamilies, linkageEquilibriumDag, gL2, bl, this.par.nsamples(), arrayList, this.par.nthreads());
        this.duoSample(nuclearFamilies, linkageEquilibriumDag, gL2, bl, this.par.nsamples(), arrayList);
        this.trioSample(nuclearFamilies, linkageEquilibriumDag, gL2, bl, this.par.nsamples(), arrayList);
        return new ArrayList<HapPair>(arrayList);
    }

    public List<HapPair> sample(boolean bl, GL gL, List<HapPair> list, NuclearFamilies nuclearFamilies, Weights weights) {
        if (!nuclearFamilies.samples().equals(gL.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (!gL.markers().equals(this.hapsMarkers(list))) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        ArrayList<HapPair> arrayList = new ArrayList(list.size());
        BasicHapPairs basicHapPairs = new BasicHapPairs(list, bl);
        float[] fArray = weights.get(basicHapPairs);
        Dag dag = this.singleDag(nuclearFamilies, basicHapPairs, fArray);
        Dag dag2 = this.duoDag(nuclearFamilies, dag, basicHapPairs, fArray);
        Dag dag3 = this.trioDag(nuclearFamilies, dag, dag2, basicHapPairs, fArray);
        this.setDagStats(dag, dag2, dag3);
        if (bl) {
            gL = new RevGL(gL);
        }
        arrayList = Collections.synchronizedList(arrayList);
        this.singleSample(nuclearFamilies, dag, gL, bl, this.par.nsamples(), arrayList, this.par.nthreads());
        this.duoSample(nuclearFamilies, dag2, gL, bl, this.par.nsamples(), arrayList);
        this.trioSample(nuclearFamilies, dag3, gL, bl, this.par.nsamples(), arrayList);
        return new ArrayList<HapPair>(arrayList);
    }

    public List<HapPair> sample(boolean bl, GL gL, List<HapPair> list, GenotypeValues genotypeValues, NuclearFamilies nuclearFamilies, Weights weights) {
        if (!nuclearFamilies.samples().equals(gL.samples()) || !nuclearFamilies.samples().equals(genotypeValues.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (!gL.markers().equals(this.hapsMarkers(list)) || !gL.markers().equals(genotypeValues.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        BasicHapPairs basicHapPairs = new BasicHapPairs(list, bl);
        float[] fArray = weights.get(basicHapPairs);
        Dag dag = this.singleDag(nuclearFamilies, basicHapPairs, fArray);
        Dag dag2 = this.duoDag(nuclearFamilies, dag, basicHapPairs, fArray);
        Dag dag3 = this.trioDag(nuclearFamilies, dag, dag2, basicHapPairs, fArray);
        this.setDagStats(dag, dag2, dag3);
        if (bl) {
            gL = new RevGL(gL);
            genotypeValues = new RevGenotypeValues(genotypeValues);
        }
        ArrayList<HapPair> arrayList = new ArrayList(list.size());
        arrayList = Collections.synchronizedList(arrayList);
        this.singleSample(nuclearFamilies, dag, gL, bl, this.par.nsamples(), arrayList, genotypeValues, this.par.nthreads());
        this.duoSample(nuclearFamilies, dag2, gL, bl, this.par.nsamples(), arrayList, genotypeValues);
        this.trioSample(nuclearFamilies, dag3, gL, bl, this.par.nsamples(), arrayList, genotypeValues);
        return new ArrayList<HapPair>(arrayList);
    }

    public List<HapPair> sample(boolean bl, AL aL, List<HapPair> list, GenotypeValues genotypeValues, Weights weights) {
        if (!aL.markers().equals(this.hapsMarkers(list)) || !aL.markers().equals(genotypeValues.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        BasicHapPairs basicHapPairs = new BasicHapPairs(list, bl);
        float[] fArray = weights.get(basicHapPairs);
        Dag dag = this.makeDag(basicHapPairs, fArray, this.par.buildwindow(), this.par.singlescale());
        this.setDagStats(dag, null, null);
        if (bl) {
            aL = new RevAL(aL);
            genotypeValues = new RevGenotypeValues(genotypeValues);
        }
        ArrayList<HapPair> arrayList = new ArrayList(list.size());
        arrayList = Collections.synchronizedList(arrayList);
        this.hapSample(dag, aL, bl, this.par.nsamples(), arrayList, genotypeValues, this.par.nthreads());
        return new ArrayList<HapPair>(arrayList);
    }

    private Markers hapsMarkers(List<HapPair> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("haps.isEmpty()");
        }
        return list.get(0).markers();
    }

    private Dag singleDag(NuclearFamilies nuclearFamilies, HapPairs hapPairs, float[] fArray) {
        if (nuclearFamilies.nSingles() > 0) {
            return this.makeDag(hapPairs, fArray, this.par.buildwindow(), this.par.singlescale());
        }
        return null;
    }

    private Dag duoDag(NuclearFamilies nuclearFamilies, Dag dag, HapPairs hapPairs, float[] fArray) {
        if (nuclearFamilies.nDuos() > 0) {
            if (nuclearFamilies.nSingles() > 0 && this.par.singlescale() == this.par.duoscale()) {
                return dag;
            }
            return this.makeDag(hapPairs, fArray, this.par.buildwindow(), this.par.duoscale());
        }
        return null;
    }

    private Dag trioDag(NuclearFamilies nuclearFamilies, Dag dag, Dag dag2, HapPairs hapPairs, float[] fArray) {
        if (nuclearFamilies.nTrios() > 0) {
            if (nuclearFamilies.nSingles() > 0 && this.par.singlescale() == this.par.trioscale()) {
                return dag;
            }
            if (nuclearFamilies.nDuos() > 0 && this.par.duoscale() == this.par.trioscale()) {
                return dag2;
            }
            return this.makeDag(hapPairs, fArray, this.par.buildwindow(), this.par.trioscale());
        }
        return null;
    }

    private void setDagStats(Dag dag, Dag dag2, Dag dag3) {
        this.runStats.setSingleDagStats(dag);
        this.runStats.setDuoDagStats(dag2);
        this.runStats.setTrioDagStats(dag3);
    }

    private void singleSample(NuclearFamilies nuclearFamilies, Dag dag, GL gL, boolean bl, int n, List<HapPair> list, int n2) {
        if (nuclearFamilies.nSingles() > 0) {
            int n3;
            long l = System.currentTimeMillis();
            Random random = new Random(this.par.seed());
            ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
            ExecutorService executorService = Executors.newFixedThreadPool(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                SingleBaum singleBaum = new SingleBaum(dag, gL, random.nextLong(), n);
                executorService.submit(new ProduceSingleSamples(bl, singleBaum, arrayBlockingQueue, list));
            }
            try {
                int n4 = nuclearFamilies.nSingles();
                for (n3 = 0; n3 < n4; ++n3) {
                    arrayBlockingQueue.put(nuclearFamilies.single(n3));
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    arrayBlockingQueue.put(ProduceSingleSamples.POISON);
                }
                executorService.shutdown();
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (Throwable throwable) {
                Utilities.exit("\"HapSampler: ERROR\"", throwable);
            }
            this.runStats.singleSampleMillis(System.currentTimeMillis() - l);
        }
    }

    private void duoSample(NuclearFamilies nuclearFamilies, Dag dag, GL gL, boolean bl, int n, List<HapPair> list) {
        if (nuclearFamilies.nDuos() > 0) {
            long l = System.currentTimeMillis();
            DuoBaum duoBaum = new DuoBaum(dag, gL, this.par.seed(), n);
            int n2 = nuclearFamilies.nDuos();
            for (int i = 0; i < n2; ++i) {
                List<HapPair> list2 = duoBaum.sample(nuclearFamilies.duoParent(i), nuclearFamilies.duoOffspring(i));
                this.storeHaps(list, bl, list2);
            }
            this.runStats.duoSampleMillis(System.currentTimeMillis() - l);
        }
    }

    private void trioSample(NuclearFamilies nuclearFamilies, Dag dag, GL gL, boolean bl, int n, List<HapPair> list) {
        if (nuclearFamilies.nTrios() > 0) {
            long l = System.currentTimeMillis();
            TrioBaum trioBaum = new TrioBaum(dag, gL, this.par.seed(), n);
            int n2 = nuclearFamilies.nTrios();
            for (int i = 0; i < n2; ++i) {
                List<HapPair> list2 = trioBaum.sample(nuclearFamilies.trioFather(i), nuclearFamilies.trioMother(i), nuclearFamilies.trioOffspring(i));
                this.storeHaps(list, bl, list2);
            }
            this.runStats.trioSampleMillis(System.currentTimeMillis() - l);
        }
    }

    private void hapSample(Dag dag, AL aL, boolean bl, int n, List<HapPair> list, GenotypeValues genotypeValues, int n2) {
        int n3;
        long l = System.currentTimeMillis();
        Random random = new Random(this.par.seed());
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            HapBaum hapBaum = new HapBaum(dag, aL, random.nextLong(), n);
            executorService.submit(new ProduceHapSamples(bl, hapBaum, arrayBlockingQueue, list, genotypeValues));
        }
        try {
            int n4 = genotypeValues.nSamples();
            for (n3 = 0; n3 < n4; ++n3) {
                arrayBlockingQueue.put(n3);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                arrayBlockingQueue.put(ProduceSingleSamples.POISON);
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("\"HapSampler: ERROR\"", throwable);
        }
        this.runStats.singleSampleMillis(System.currentTimeMillis() - l);
    }

    private void singleSample(NuclearFamilies nuclearFamilies, Dag dag, GL gL, boolean bl, int n, List<HapPair> list, GenotypeValues genotypeValues, int n2) {
        if (nuclearFamilies.nSingles() > 0) {
            int n3;
            long l = System.currentTimeMillis();
            Random random = new Random(this.par.seed());
            ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(3 * n2);
            ExecutorService executorService = Executors.newFixedThreadPool(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                SingleBaum singleBaum = new SingleBaum(dag, gL, random.nextLong(), n);
                executorService.submit(new ProduceSingleSamples(bl, singleBaum, arrayBlockingQueue, list, genotypeValues));
            }
            try {
                int n4 = nuclearFamilies.nSingles();
                for (n3 = 0; n3 < n4; ++n3) {
                    arrayBlockingQueue.put(nuclearFamilies.single(n3));
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    arrayBlockingQueue.put(ProduceSingleSamples.POISON);
                }
                executorService.shutdown();
                executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            }
            catch (Throwable throwable) {
                Utilities.exit("\"HapSampler: ERROR\"", throwable);
            }
            this.runStats.singleSampleMillis(System.currentTimeMillis() - l);
        }
    }

    private void duoSample(NuclearFamilies nuclearFamilies, Dag dag, GL gL, boolean bl, int n, List<HapPair> list, GenotypeValues genotypeValues) {
        if (nuclearFamilies.nDuos() > 0) {
            long l = System.currentTimeMillis();
            int n2 = gL.markers().sumGenotypes();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            DuoBaum duoBaum = new DuoBaum(dag, gL, this.par.seed(), n);
            int n3 = nuclearFamilies.nDuos();
            for (int i = 0; i < n3; ++i) {
                List<HapPair> list2 = duoBaum.sample(nuclearFamilies.duoParent(i), nuclearFamilies.duoOffspring(i), dArray, dArray2);
                this.storeHaps(list, bl, list2);
                genotypeValues.add(nuclearFamilies.duoParent(i), dArray);
                genotypeValues.add(nuclearFamilies.duoOffspring(i), dArray2);
            }
            this.runStats.duoSampleMillis(System.currentTimeMillis() - l);
        }
    }

    private void trioSample(NuclearFamilies nuclearFamilies, Dag dag, GL gL, boolean bl, int n, List<HapPair> list, GenotypeValues genotypeValues) {
        if (nuclearFamilies.nTrios() > 0) {
            long l = System.currentTimeMillis();
            int n2 = gL.markers().sumGenotypes();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[n2];
            TrioBaum trioBaum = new TrioBaum(dag, gL, this.par.seed(), n);
            int n3 = nuclearFamilies.nTrios();
            for (int i = 0; i < n3; ++i) {
                List<HapPair> list2 = trioBaum.sample(nuclearFamilies.trioFather(i), nuclearFamilies.trioMother(i), nuclearFamilies.trioOffspring(i), dArray, dArray2, dArray3);
                this.storeHaps(list, bl, list2);
                genotypeValues.add(nuclearFamilies.trioFather(i), dArray);
                genotypeValues.add(nuclearFamilies.trioMother(i), dArray2);
                genotypeValues.add(nuclearFamilies.trioOffspring(i), dArray3);
            }
            this.runStats.trioSampleMillis(System.currentTimeMillis() - l);
        }
    }

    private void storeHaps(List<HapPair> list, boolean bl, List<HapPair> list2) {
        if (bl) {
            for (HapPair hapPair : list2) {
                list.add(new RevHapPair(hapPair));
            }
        } else {
            list.addAll(list2);
        }
    }

    private Dag makeDag(HapPairs hapPairs, float[] fArray, int n, float f) {
        long l = System.currentTimeMillis();
        Dag dag = MergeableDag.dag(hapPairs, fArray, n, f);
        this.runStats.buildMillis(System.currentTimeMillis() - l);
        return dag;
    }
}

