% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inclination_to_overtriage.R
\name{get_inclination_to_overtriage}
\alias{get_inclination_to_overtriage}
\title{get_inclination_to_overtriage}
\usage{
get_inclination_to_overtriage(
  data,
  triagelevel_correct,
  triagelevel_advice,
  order_triagelevel,
  apps = NULL
)
}
\arguments{
\item{data}{A dataframe}

\item{triagelevel_correct}{A string indicating the column name storing the correct triage solutions}

\item{triagelevel_advice}{A string indicating the column name storing the recommendation of a symptom checker for a case}

\item{order_triagelevel}{A vector indicating the order of triage levels. The triage level with highest urgency should be the first value and the triage level with lowest urgency the last value.}

\item{apps}{A string indicating the column name storing the app names (optional)}
}
\value{
A list containing both a raw number and the percentage of the inclination to overtriage for one or multiple symptom checkers
}
\description{
Calculates the inclination to overtriage for one or multiple symptom checkers
}
\examples{
data(symptomcheckRdata)
inclination_to_overtriage <- get_inclination_to_overtriage(
  data = symptomcheckRdata,
   triagelevel_correct = "Goldstandard_solution",
   triagelevel_advice = "Triage_advice_from_app",
   order_triagelevel = c("Emergency", "Non-Emergency", "Self-care"),
   apps = "App_name"
   )
}
