% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{substituteVariables}
\alias{substituteVariables}
\title{Assign values to the variables of a 'symbolicQspray'}
\usage{
substituteVariables(Qspray, values)
}
\arguments{
\item{Qspray}{a \code{symbolicQspray} object}

\item{values}{vector of values to be substituted to the parameters; these
values must be coercible to \code{bigq} numbers}
}
\value{
A \code{ratioOfQsprays} object.
}
\description{
Substitutes some values to the variables of a
  \code{symbolicQspray} polynomial.
}
\examples{
library(symbolicQspray)
f <- function(a1, a2, X, Y) {
  (a1 + 2)*X^2*Y + (a2/(a1^2+a2))*X*Y
}
a1 <- qlone(1); a2 <- qlone(2)
Qspray <- f(a1, a2, Qlone(1), Qlone(2))
values <- c(3, "2/3")
( rOQ <- substituteVariables(Qspray, values) )
values <- gmp::as.bigq(values)
rOQ == f(a1, a2, values[1], values[2]) ## should be TRUE
}
\seealso{
Use \code{\link{changeVariables}} to apply a transformation of the
  variables. Use \code{\link{substituteParameters}} to substitute some
  values to the parameters.
}
