% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which.nearest.R
\name{which.nearest}
\alias{which.nearest}
\title{Which Nearest}
\usage{
which.nearest(x, y)
}
\arguments{
\item{x}{vector of values to be compared against.}

\item{y}{vector of values to examine relative to \code{x}. May be of length 1.

 @return For each value in \code{y}, returns index of value of \code{x} which is 
   nearest to \code{y} in absolute value. In the case of ties, the function returns the
   first index of \code{x}. If nearest value is \code{min(x)} or \code{max(x)}, a warning is issued. 
   \code{NA}s and \code{NaN}s in \code{x} are ignored; \code{NA}s and \code{NaN}s in \code{y} are returned.}
}
\description{
Find values of one vector that are nearest to values in another vector.
}
\examples{
x <- sort(sample(1:100, 20))
y <- sort(sample(min(x):max(x), 5))
i <- which.nearest(x, y)
x
y
x[i]
}
\author{
Tim Gerrodette \email{tim.gerrodette@noaa.gov}
}

