% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAssignments.R
\name{plotAssignments}
\alias{plotAssignments}
\title{Plot assignment distributions}
\usage{
plotAssignments(probs, orig, type = NULL, ylab = NULL, plot = TRUE)
}
\arguments{
\item{probs}{matrix or data.frame of individual assignment probabilities. 
Each column represents probability of assignment to that group and rows sum 
to one.}

\item{orig}{vector of original group assignments}

\item{type}{either \code{area} for stacked continuous area plot or 
\code{bar} for discrete stacked bar chart. The latter is prefered for small 
numbers of cases. If not specified, a bar chart will be used if all 
classes have <= 30 cases.}

\item{ylab}{label for y-axis}

\item{plot}{display the plot?}
}
\value{
the \code{ggplot} object is invisibly returned.
}
\description{
Plot individual assignment probability distributions.
}
\examples{
n <- 40
probs <- abs(c(rnorm(n, 80, 10), rnorm(n, 20, 10)))
probs <- (probs - min(probs)) / max(probs)
probs <- cbind(probs, 1 - probs)
colnames(probs) <- NULL
orig <- rep(c("Group.1", "Group.2"), each = n)

plotAssignments(probs, orig)

n <- 15
probs <- abs(c(rnorm(n, 80, 10), rnorm(n, 20, 10)))
probs <- (probs - min(probs)) / max(probs)
probs <- cbind(probs, 1 - probs)
colnames(probs) <- NULL
orig <- rep(c("Group.1", "Group.2"), each = n)

plotAssignments(probs, orig)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

