% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_idxs.R
\name{get_event_ids}
\alias{get_event_ids}
\title{Event Indexes}
\usage{
get_event_ids(df)
}
\arguments{
\item{df}{A dataframe with a set and a keep column to get the timeseries of
event IDs. The \code{keep} column is added by the
\code{\link{define_events}} function and represents whether each timestep is
part of an event or not (whether it should be kept in for the rest of the
analysis). Each set of the dataframe should be ordered in time.}
}
\value{
a vector of the same length as the rows of the input dataframe with
 the timeseries of event IDs.
}
\description{
This function returns a vector with the timeseries of event IDs
 according to the input keep column of the dataframe.
}
\examples{
data <- data.frame(
set = c(rep('1', 50), rep('2', 50)),
keep = c(rep(FALSE, 10), rep(TRUE, 70), rep(FALSE, 20))
)
data$event <- get_event_ids(data)

}
\seealso{
\code{\link{define_events}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
