% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_metrics.R
\name{event_metrics}
\alias{event_metrics}
\title{Metrics of Collective Motion}
\usage{
event_metrics(global_df, pairwise_df)
}
\arguments{
\item{global_df}{A data frame with time series of global group measurements.
Columns must include: \code{set}, \code{t}, \code{event}, \code{pol},
\code{shape}, \code{speed}.}

\item{pairwise_df}{A data frame with time series of pairwise measurements.
Columns must include: \code{set}, \code{t}, \code{id}, \code{nnd},
\code{bangl}.}
}
\value{
A dataframe with 10 metrics per event.
}
\description{
This function calculates metrics of collective motion across
 sets and events.
}
\examples{

## A dataframe with group timeseries
g_df <- data.frame(
t = 1:25,
set = rep(1, 25),
pol = c(rnorm(25)),
speed = c(rnorm(25)),
shape = c(rnorm(25)),
event = rep(1, 25),
N = rep(2, 25)
)

## A dataframe with individual timeseries
p_df <- data.frame(
t = rep(1:25, 2),
set = rep(1, 50),
nnd = c(rnorm(50)),
bangl = runif(25, 0, pi),
id = c(rep(1, 25), rep(2, 25)),
event = rep(1, 50)
)

events_dataframe <- event_metrics(g_df, p_df)

}
\seealso{
\code{\link{group_metrics}}, \code{\link{nn_metrics}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
