% Generated by roxygen2 (4.0.2): do not edit by hand
\name{weighting_functions}
\alias{gw_bin}
\alias{gw_ent}
\alias{gw_gfidf}
\alias{gw_idf}
\alias{gw_idf_alt}
\alias{gw_nor}
\alias{gw_raw}
\alias{lw_bin}
\alias{lw_log}
\alias{lw_raw}
\alias{lw_tf}
\alias{weighting_functions}
\title{Weighting Functions}
\usage{
lw_tf(x)

lw_raw(x)

lw_log(x)

lw_bin(x)

gw_idf(x)

gw_idf_alt(x)

gw_gfidf(x)

gw_nor(x)

gw_ent(x)

gw_bin(x)

gw_raw(x)
}
\arguments{
\item{x}{A numeric matrix.}
}
\value{
A numeric matrix.
}
\description{
Local and global weighting functions.
}
\details{
There are many local and global weighting functions. In this package, local weighting functions are prefixed with \code{lw_} and
  global weighting functions with \code{gw_}, so users can define their own weighting functions.

Local weighting functions (i.e. weighting every cell in the matrix):
\itemize{
  \item{\code{lw_tf} }{Term frequency: \emph{f(x) = x}.}
  \item{\code{lw_raw} }{Raw frequency, which is the same as the term frequency: \emph{f(x) = x}.}
  \item{\code{lw_log} }{Logarithm: \emph{f(x) = log(x + 1)}.}
  \item{\code{lw_bin} }{Binary: \emph{f(x) = 1} if \emph{x > 0} and \emph{0} otherwise.}
}

Global weighting functions, weighting the columns of the matrix (hence, these weighting functions work according to expectation for
  a document-term matrix, i.e. with the documents as the rows and the terms as the columns):
\itemize{
  \item{\code{gw_idf} }{Inverse document frequency: \emph{f(x) = log( nrow(x) / n + 1)} where \emph{n =} the number of rows in which the column \emph{>0}.}
  \item{\code{gw_idf_alt} }{Alternative definition of the inverse document frequency: \emph{f(x) = log( nrow(x) / n) + 1} where \emph{n =} the number of rows in which the column \emph{>0}.}
  \item{\code{gw_gfidf} }{Global frequency multiplied by inverse document frequency: \emph{f(x) = colSums(x) / n} where \emph{n =} the number of rows in which the column \emph{>0}.}
  \item{\code{gw_nor} }{Normal(ized) frequency: \emph{f(x) = x / colSums(x^2)}.}
  \item{\code{gw_ent} }{Entropy: \emph{f(x) = 1 +} the relative Shannon entropy.}
  \item{\code{gw_bin} }{Binary: \emph{f(x) = 1}.}
  \item{\code{gw_raw} }{Raw, which is the same as binary: \emph{f(x) = 1}.}
}
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
tab.SndT_Fra <- table(SndT_Fra)
lw_log(tab.SndT_Fra)
gw_idf(tab.SndT_Fra)
}
\seealso{
\code{\link{fast_lsa}}.
}

