% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svine.R
\name{svine}
\alias{svine}
\title{Stationary vine distribution models}
\usage{
svine(
  data,
  p,
  margin_families = univariateML::univariateML_models,
  selcrit = "aic",
  ...
)
}
\arguments{
\item{data}{a matrix or data.frame of data.}

\item{p}{the Markov order.}

\item{margin_families}{either a vector of \link[univariateML:univariateML_models]{univariateML::univariateML_models} to select
from (used for every margin) or a list with one entry for every variable.
Can also be \code{"empirical"} for empirical cdfs.}

\item{selcrit}{criterion for family selection, either \code{"loglik"}, \code{"aic"},
\code{"bic"}, \code{"mbicv"}.}

\item{...}{arguments passed to \code{svinecop()}.}
}
\value{
Returns the fitted model as an object with classes
\code{svine} and \link{svine_dist}. A list with entries
\itemize{
\item \verb{$margins}: list of marginal models from \link[univariateML:univariateML_models]{univariateML::univariateML_models},
\item \verb{$copula}: an object of \code{svinecop_dist}.
}
}
\description{
Automated fitting or creation of custom S-vine distribution models
}
\examples{
# load data set
data(returns)  

# fit parametric S-vine model with Markov order 1
fit <- svine(returns[1:100, 1:3], p = 1, family_set = "parametric")
fit 
summary(fit)
plot(fit$copula)
contour(fit$copula)
logLik(fit)

pairs(svine_sim(500, rep = 1, fit))
}
\seealso{
\link{svine_dist}, \link{svine_loglik}, \link{svine_sim}, \link{svine_bootstrap_models}
}
