% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.svars.R
\name{irf}
\alias{irf}
\alias{irf.svars}
\title{Impulse Response Functions for SVAR Models}
\usage{
\method{irf}{svars}(x, ..., n.ahead = 20)
}
\arguments{
\item{x}{SVAR object of class "svars".}

\item{...}{Currently not used.}

\item{n.ahead}{Integer specifying the steps.}
}
\value{
A list with class attribute "svarirf" holding the impulse response functions as data frame.
}
\description{
Calculation of impulse response functions for an identified SVAR object 'svars' derived by function id.cvm( ),id.cv( ),id.dc( ), id.ngml( ) or id.st( ).
}
\examples{
\donttest{
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.ngml(v1)
x2 <- irf(x1, n.ahead = 20)
plot(x2)
}

}
\references{
Luetkepohl, H., 2005. New introduction to multiple time series analysis, Springer-Verlag, Berlin.
}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.dc}}, \code{\link{id.ngml}}, \code{\link{id.cv}} or \code{\link{id.st}}
}
