// Generated by rstantools.  Do not edit by hand.

/*
    survstan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    survstan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with survstan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_survreg_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'survreg', line 146, column 2 to column 30)",
                                                      " (in 'survreg', line 147, column 2 to column 34)",
                                                      " (in 'survreg', line 148, column 2 to column 51)",
                                                      " (in 'survreg', line 149, column 2 to column 51)",
                                                      " (in 'survreg', line 150, column 2 to column 53)",
                                                      " (in 'survreg', line 151, column 2 to column 36)",
                                                      " (in 'survreg', line 152, column 2 to column 52)",
                                                      " (in 'survreg', line 155, column 9 to column 10)",
                                                      " (in 'survreg', line 155, column 2 to column 15)",
                                                      " (in 'survreg', line 156, column 9 to column 10)",
                                                      " (in 'survreg', line 156, column 2 to column 14)",
                                                      " (in 'survreg', line 157, column 9 to column 10)",
                                                      " (in 'survreg', line 157, column 2 to column 19)",
                                                      " (in 'survreg', line 158, column 9 to column 10)",
                                                      " (in 'survreg', line 158, column 2 to column 17)",
                                                      " (in 'survreg', line 159, column 9 to column 10)",
                                                      " (in 'survreg', line 159, column 2 to column 18)",
                                                      " (in 'survreg', line 160, column 9 to column 29)",
                                                      " (in 'survreg', line 160, column 2 to column 39)",
                                                      " (in 'survreg', line 161, column 9 to column 29)",
                                                      " (in 'survreg', line 161, column 2 to column 37)",
                                                      " (in 'survreg', line 165, column 4 to column 15)",
                                                      " (in 'survreg', line 164, column 7 to line 166, column 3)",
                                                      " (in 'survreg', line 163, column 4 to column 16)",
                                                      " (in 'survreg', line 162, column 9 to line 164, column 3)",
                                                      " (in 'survreg', line 162, column 2 to line 166, column 3)",
                                                      " (in 'survreg', line 172, column 4 to column 13)",
                                                      " (in 'survreg', line 171, column 7 to line 173, column 3)",
                                                      " (in 'survreg', line 170, column 4 to column 24)",
                                                      " (in 'survreg', line 169, column 24 to line 171, column 3)",
                                                      " (in 'survreg', line 169, column 8 to line 173, column 3)",
                                                      " (in 'survreg', line 168, column 4 to column 24)",
                                                      " (in 'survreg', line 167, column 18 to line 169, column 3)",
                                                      " (in 'survreg', line 167, column 2 to line 173, column 3)",
                                                      " (in 'survreg', line 196, column 6 to column 54)",
                                                      " (in 'survreg', line 197, column 6 to column 56)",
                                                      " (in 'survreg', line 195, column 17 to line 198, column 5)",
                                                      " (in 'survreg', line 195, column 4 to line 198, column 5)",
                                                      " (in 'survreg', line 194, column 25 to line 199, column 3)",
                                                      " (in 'survreg', line 194, column 8 to line 199, column 3)",
                                                      " (in 'survreg', line 191, column 6 to column 59)",
                                                      " (in 'survreg', line 192, column 6 to column 61)",
                                                      " (in 'survreg', line 190, column 17 to line 193, column 5)",
                                                      " (in 'survreg', line 190, column 4 to line 193, column 5)",
                                                      " (in 'survreg', line 189, column 25 to line 194, column 3)",
                                                      " (in 'survreg', line 189, column 8 to line 199, column 3)",
                                                      " (in 'survreg', line 186, column 6 to column 47)",
                                                      " (in 'survreg', line 187, column 6 to column 49)",
                                                      " (in 'survreg', line 185, column 17 to line 188, column 5)",
                                                      " (in 'survreg', line 185, column 4 to line 188, column 5)",
                                                      " (in 'survreg', line 184, column 25 to line 189, column 3)",
                                                      " (in 'survreg', line 184, column 8 to line 199, column 3)",
                                                      " (in 'survreg', line 181, column 10 to column 52)",
                                                      " (in 'survreg', line 182, column 10 to column 54)",
                                                      " (in 'survreg', line 180, column 17 to line 183, column 5)",
                                                      " (in 'survreg', line 180, column 4 to line 183, column 5)",
                                                      " (in 'survreg', line 179, column 25 to line 184, column 3)",
                                                      " (in 'survreg', line 179, column 8 to line 199, column 3)",
                                                      " (in 'survreg', line 176, column 6 to column 46)",
                                                      " (in 'survreg', line 177, column 6 to column 48)",
                                                      " (in 'survreg', line 175, column 17 to line 178, column 5)",
                                                      " (in 'survreg', line 175, column 4 to line 178, column 5)",
                                                      " (in 'survreg', line 174, column 19 to line 179, column 3)",
                                                      " (in 'survreg', line 174, column 2 to line 199, column 3)",
                                                      " (in 'survreg', line 213, column 8 to column 24)",
                                                      " (in 'survreg', line 214, column 8 to column 27)",
                                                      " (in 'survreg', line 212, column 11 to line 215, column 7)",
                                                      " (in 'survreg', line 210, column 8 to column 24)",
                                                      " (in 'survreg', line 211, column 8 to column 35)",
                                                      " (in 'survreg', line 209, column 13 to line 212, column 7)",
                                                      " (in 'survreg', line 209, column 6 to line 215, column 7)",
                                                      " (in 'survreg', line 216, column 4 to column 68)",
                                                      " (in 'survreg', line 208, column 7 to line 217, column 3)",
                                                      " (in 'survreg', line 207, column 4 to column 52)",
                                                      " (in 'survreg', line 206, column 24 to line 208, column 3)",
                                                      " (in 'survreg', line 206, column 8 to line 217, column 3)",
                                                      " (in 'survreg', line 205, column 4 to column 52)",
                                                      " (in 'survreg', line 204, column 24 to line 206, column 3)",
                                                      " (in 'survreg', line 204, column 8 to line 217, column 3)",
                                                      " (in 'survreg', line 203, column 4 to column 52)",
                                                      " (in 'survreg', line 202, column 24 to line 204, column 3)",
                                                      " (in 'survreg', line 202, column 8 to line 217, column 3)",
                                                      " (in 'survreg', line 201, column 4 to column 53)",
                                                      " (in 'survreg', line 200, column 19 to line 202, column 3)",
                                                      " (in 'survreg', line 200, column 2 to line 217, column 3)",
                                                      " (in 'survreg', line 218, column 2 to column 24)",
                                                      " (in 'survreg', line 104, column 2 to column 8)",
                                                      " (in 'survreg', line 105, column 2 to column 8)",
                                                      " (in 'survreg', line 106, column 9 to column 10)",
                                                      " (in 'survreg', line 106, column 2 to column 17)",
                                                      " (in 'survreg', line 107, column 9 to column 10)",
                                                      " (in 'survreg', line 107, column 2 to column 18)",
                                                      " (in 'survreg', line 108, column 9 to column 23)",
                                                      " (in 'survreg', line 108, column 25 to column 26)",
                                                      " (in 'survreg', line 108, column 2 to column 30)",
                                                      " (in 'survreg', line 109, column 2 to column 11)",
                                                      " (in 'survreg', line 110, column 2 to column 15)",
                                                      " (in 'survreg', line 111, column 2 to column 14)",
                                                      " (in 'survreg', line 114, column 2 to column 19)",
                                                      " (in 'survreg', line 115, column 2 to column 19)",
                                                      " (in 'survreg', line 116, column 2 to column 20)",
                                                      " (in 'survreg', line 117, column 2 to column 16)",
                                                      " (in 'survreg', line 118, column 2 to column 19)",
                                                      " (in 'survreg', line 119, column 2 to column 17)",
                                                      " (in 'survreg', line 120, column 9 to column 23)",
                                                      " (in 'survreg', line 120, column 2 to column 31)",
                                                      " (in 'survreg', line 123, column 6 to column 19)",
                                                      " (in 'survreg', line 122, column 17 to line 124, column 5)",
                                                      " (in 'survreg', line 122, column 4 to line 124, column 5)",
                                                      " (in 'survreg', line 121, column 10 to line 125, column 3)",
                                                      " (in 'survreg', line 121, column 2 to line 125, column 3)",
                                                      " (in 'survreg', line 138, column 4 to column 17)",
                                                      " (in 'survreg', line 139, column 4 to column 17)",
                                                      " (in 'survreg', line 137, column 25 to line 140, column 3)",
                                                      " (in 'survreg', line 137, column 8 to line 140, column 3)",
                                                      " (in 'survreg', line 135, column 4 to column 17)",
                                                      " (in 'survreg', line 136, column 4 to column 17)",
                                                      " (in 'survreg', line 134, column 25 to line 137, column 3)",
                                                      " (in 'survreg', line 134, column 8 to line 140, column 3)",
                                                      " (in 'survreg', line 132, column 4 to column 14)",
                                                      " (in 'survreg', line 133, column 4 to column 17)",
                                                      " (in 'survreg', line 131, column 25 to line 134, column 3)",
                                                      " (in 'survreg', line 131, column 8 to line 140, column 3)",
                                                      " (in 'survreg', line 129, column 4 to column 17)",
                                                      " (in 'survreg', line 130, column 4 to column 17)",
                                                      " (in 'survreg', line 128, column 25 to line 131, column 3)",
                                                      " (in 'survreg', line 128, column 8 to line 140, column 3)",
                                                      " (in 'survreg', line 127, column 4 to column 18)",
                                                      " (in 'survreg', line 126, column 19 to line 128, column 3)",
                                                      " (in 'survreg', line 126, column 2 to line 140, column 3)",
                                                      " (in 'survreg', line 142, column 4 to column 15)",
                                                      " (in 'survreg', line 141, column 18 to line 143, column 3)",
                                                      " (in 'survreg', line 141, column 2 to line 143, column 3)",
                                                      " (in 'survreg', line 146, column 9 to column 23)",
                                                      " (in 'survreg', line 147, column 9 to column 28)",
                                                      " (in 'survreg', line 148, column 8 to column 29)",
                                                      " (in 'survreg', line 149, column 8 to column 29)",
                                                      " (in 'survreg', line 150, column 8 to column 30)",
                                                      " (in 'survreg', line 151, column 8 to column 26)",
                                                      " (in 'survreg', line 152, column 8 to column 30)",
                                                      " (in 'survreg', line 9, column 2 to column 40)",
                                                      " (in 'survreg', line 10, column 2 to line 11, column 36)",
                                                      " (in 'survreg', line 12, column 2 to column 14)",
                                                      " (in 'survreg', line 8, column 54 to line 13, column 1)",
                                                      " (in 'survreg', line 16, column 2 to column 44)",
                                                      " (in 'survreg', line 17, column 2 to column 15)",
                                                      " (in 'survreg', line 15, column 55 to line 18, column 1)",
                                                      " (in 'survreg', line 24, column 2 to column 26)",
                                                      " (in 'survreg', line 25, column 2 to column 26)",
                                                      " (in 'survreg', line 28, column 2 to column 27)",
                                                      " (in 'survreg', line 29, column 2 to column 80)",
                                                      " (in 'survreg', line 30, column 2 to column 14)",
                                                      " (in 'survreg', line 23, column 49 to line 31, column 1)",
                                                      " (in 'survreg', line 34, column 2 to column 26)",
                                                      " (in 'survreg', line 35, column 2 to column 26)",
                                                      " (in 'survreg', line 38, column 2 to column 29)",
                                                      " (in 'survreg', line 39, column 2 to column 30)",
                                                      " (in 'survreg', line 33, column 50 to line 40, column 1)",
                                                      " (in 'survreg', line 46, column 2 to column 29)",
                                                      " (in 'survreg', line 47, column 9 to column 10)",
                                                      " (in 'survreg', line 47, column 2 to column 19)",
                                                      " (in 'survreg', line 48, column 2 to column 65)",
                                                      " (in 'survreg', line 49, column 2 to column 16)",
                                                      " (in 'survreg', line 45, column 79 to line 50, column 1)",
                                                      " (in 'survreg', line 54, column 2 to column 29)",
                                                      " (in 'survreg', line 55, column 9 to column 10)",
                                                      " (in 'survreg', line 55, column 2 to column 19)",
                                                      " (in 'survreg', line 56, column 2 to column 69)",
                                                      " (in 'survreg', line 57, column 2 to column 16)",
                                                      " (in 'survreg', line 53, column 78 to line 58, column 1)",
                                                      " (in 'survreg', line 62, column 2 to column 29)",
                                                      " (in 'survreg', line 63, column 9 to column 10)",
                                                      " (in 'survreg', line 63, column 2 to column 19)",
                                                      " (in 'survreg', line 64, column 9 to column 10)",
                                                      " (in 'survreg', line 64, column 2 to column 31)",
                                                      " (in 'survreg', line 65, column 2 to column 64)",
                                                      " (in 'survreg', line 66, column 2 to column 16)",
                                                      " (in 'survreg', line 61, column 78 to line 67, column 1)",
                                                      " (in 'survreg', line 71, column 2 to column 29)",
                                                      " (in 'survreg', line 72, column 9 to column 10)",
                                                      " (in 'survreg', line 72, column 2 to column 31)",
                                                      " (in 'survreg', line 73, column 9 to column 10)",
                                                      " (in 'survreg', line 73, column 2 to column 25)",
                                                      " (in 'survreg', line 74, column 9 to column 10)",
                                                      " (in 'survreg', line 74, column 2 to column 39)",
                                                      " (in 'survreg', line 75, column 9 to column 10)",
                                                      " (in 'survreg', line 75, column 2 to column 83)",
                                                      " (in 'survreg', line 76, column 2 to column 16)",
                                                      " (in 'survreg', line 70, column 78 to line 77, column 1)",
                                                      " (in 'survreg', line 82, column 2 to column 29)",
                                                      " (in 'survreg', line 83, column 9 to column 10)",
                                                      " (in 'survreg', line 83, column 2 to column 16)",
                                                      " (in 'survreg', line 84, column 9 to column 10)",
                                                      " (in 'survreg', line 84, column 2 to column 19)",
                                                      " (in 'survreg', line 85, column 9 to column 10)",
                                                      " (in 'survreg', line 85, column 2 to column 19)",
                                                      " (in 'survreg', line 86, column 9 to column 10)",
                                                      " (in 'survreg', line 86, column 2 to column 19)",
                                                      " (in 'survreg', line 87, column 9 to column 10)",
                                                      " (in 'survreg', line 87, column 2 to column 18)",
                                                      " (in 'survreg', line 88, column 9 to column 10)",
                                                      " (in 'survreg', line 88, column 2 to column 16)",
                                                      " (in 'survreg', line 89, column 9 to column 10)",
                                                      " (in 'survreg', line 89, column 2 to column 43)",
                                                      " (in 'survreg', line 90, column 9 to column 10)",
                                                      " (in 'survreg', line 90, column 2 to column 25)",
                                                      " (in 'survreg', line 92, column 2 to column 19)",
                                                      " (in 'survreg', line 93, column 2 to column 23)",
                                                      " (in 'survreg', line 95, column 2 to column 21)",
                                                      " (in 'survreg', line 96, column 2 to column 46)",
                                                      " (in 'survreg', line 97, column 2 to column 32)",
                                                      " (in 'survreg', line 98, column 2 to column 37)",
                                                      " (in 'survreg', line 100, column 2 to column 16)",
                                                      " (in 'survreg', line 80, column 115 to line 101, column 1)"};
template <bool propto__, typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
loglogistic2_lpdf(const T0__& x, const T1__& alpha, const T2__& gamma,
                  std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ aux;
    aux = DUMMY_VAR__;
    
    current_statement__ = 141;
    aux = stan::math::log1p(pow((x / gamma), alpha));
    local_scalar_t__ lpdf;
    lpdf = DUMMY_VAR__;
    
    current_statement__ = 142;
    lpdf = ((((stan::math::log(alpha) - stan::math::log(gamma)) +
               multiply_log((alpha - 1), x)) -
              multiply_log((alpha - 1), gamma)) - (2 * aux));
    current_statement__ = 143;
    return lpdf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglogistic2_lpdf_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& x, const T1__& alpha, const T2__& gamma,
           std::ostream* pstream__)  const 
{
return loglogistic2_lpdf<propto__>(x, alpha, gamma, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
loglogistic2_lccdf(const T0__& x, const T1__& alpha, const T2__& gamma,
                   std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ lsurv;
    lsurv = DUMMY_VAR__;
    
    current_statement__ = 145;
    lsurv = -stan::math::log1p(pow((x / gamma), alpha));
    current_statement__ = 146;
    return lsurv;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglogistic2_lccdf_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& x, const T1__& alpha, const T2__& gamma,
           std::ostream* pstream__)  const 
{
return loglogistic2_lccdf(x, alpha, gamma, pstream__);
}
};
template <bool propto__, typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
fatigue_lpdf(const T0__& x, const T1__& alpha, const T2__& gamma,
             std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ xg;
    xg = DUMMY_VAR__;
    
    current_statement__ = 148;
    xg = stan::math::sqrt((x / gamma));
    local_scalar_t__ gx;
    gx = DUMMY_VAR__;
    
    current_statement__ = 149;
    gx = stan::math::sqrt((gamma / x));
    local_scalar_t__ z;
    z = DUMMY_VAR__;
    
    current_statement__ = 150;
    z = ((xg - gx) / alpha);
    local_scalar_t__ lpdf;
    lpdf = DUMMY_VAR__;
    
    current_statement__ = 151;
    lpdf = ((((stan::math::log((xg + gx)) - stan::math::log2()) -
               stan::math::log(alpha)) - stan::math::log(x)) +
             normal_lpdf<false>(z, 0, 1));
    current_statement__ = 152;
    return lpdf;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct fatigue_lpdf_functor__ {
template <bool propto__, typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& x, const T1__& alpha, const T2__& gamma,
           std::ostream* pstream__)  const 
{
return fatigue_lpdf<propto__>(x, alpha, gamma, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
fatigue_lccdf(const T0__& x, const T1__& alpha, const T2__& gamma,
              std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ xg;
    xg = DUMMY_VAR__;
    
    current_statement__ = 154;
    xg = stan::math::sqrt((x / gamma));
    local_scalar_t__ gx;
    gx = DUMMY_VAR__;
    
    current_statement__ = 155;
    gx = stan::math::sqrt((gamma / x));
    local_scalar_t__ z;
    z = DUMMY_VAR__;
    
    current_statement__ = 156;
    z = ((xg - gx) / alpha);
    current_statement__ = 157;
    return normal_lcdf(-z, 0, 1);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct fatigue_lccdf_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& x, const T1__& alpha, const T2__& gamma,
           std::ostream* pstream__)  const 
{
return fatigue_lccdf(x, alpha, gamma, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
loglik_aft(const T0__& lpdf_arg__, const T1__& lsurv_arg__,
           const T2__& event_arg__, const T3__& lp_arg__, const T4__& tau,
           std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          T4__>;
  const auto& lpdf = to_ref(lpdf_arg__);
  const auto& lsurv = to_ref(lsurv_arg__);
  const auto& event = to_ref(event_arg__);
  const auto& lp = to_ref(lp_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 159;
    n = num_elements(lpdf);
    current_statement__ = 160;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 162;
    assign(loglik, nil_index_list(),
      add(
        elt_multiply(event,
          subtract(subtract(lpdf, lp), stan::math::log(tau))),
        elt_multiply(subtract(1, event), lsurv)), "assigning variable loglik");
    current_statement__ = 163;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglik_aft_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
operator()(const T0__& lpdf, const T1__& lsurv, const T2__& event,
           const T3__& lp, const T4__& tau, std::ostream* pstream__)  const 
{
return loglik_aft(lpdf, lsurv, event, lp, tau, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
loglik_ah(const T0__& lpdf_arg__, const T1__& lsurv_arg__,
          const T2__& event_arg__, const T3__& lp_arg__, const T4__& tau,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          T4__>;
  const auto& lpdf = to_ref(lpdf_arg__);
  const auto& lsurv = to_ref(lsurv_arg__);
  const auto& event = to_ref(event_arg__);
  const auto& lp = to_ref(lp_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 165;
    n = num_elements(lpdf);
    current_statement__ = 166;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 168;
    assign(loglik, nil_index_list(),
      add(
        elt_multiply(event,
          subtract(subtract(lpdf, lsurv), stan::math::log(tau))),
        elt_multiply(stan::math::exp(minus(lp)), lsurv)),
      "assigning variable loglik");
    current_statement__ = 169;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglik_ah_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
operator()(const T0__& lpdf, const T1__& lsurv, const T2__& event,
           const T3__& lp, const T4__& tau, std::ostream* pstream__)  const 
{
return loglik_ah(lpdf, lsurv, event, lp, tau, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
loglik_ph(const T0__& lpdf_arg__, const T1__& lsurv_arg__,
          const T2__& event_arg__, const T3__& lp_arg__, const T4__& tau,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          T4__>;
  const auto& lpdf = to_ref(lpdf_arg__);
  const auto& lsurv = to_ref(lsurv_arg__);
  const auto& event = to_ref(event_arg__);
  const auto& lp = to_ref(lp_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 171;
    n = num_elements(lpdf);
    current_statement__ = 172;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 174;
    validate_non_negative_index("lht", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> lht;
    lht = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(lht, DUMMY_VAR__);
    
    current_statement__ = 175;
    assign(lht, nil_index_list(), subtract(lpdf, lsurv),
      "assigning variable lht");
    current_statement__ = 176;
    assign(loglik, nil_index_list(),
      add(elt_multiply(event, subtract(add(lht, lp), stan::math::log(tau))),
        elt_multiply(stan::math::exp(lp), lsurv)),
      "assigning variable loglik");
    current_statement__ = 177;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglik_ph_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
operator()(const T0__& lpdf, const T1__& lsurv, const T2__& event,
           const T3__& lp, const T4__& tau, std::ostream* pstream__)  const 
{
return loglik_ph(lpdf, lsurv, event, lp, tau, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
loglik_po(const T0__& lpdf_arg__, const T1__& lsurv_arg__,
          const T2__& event_arg__, const T3__& lp_arg__, const T4__& tau,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          T4__>;
  const auto& lpdf = to_ref(lpdf_arg__);
  const auto& lsurv = to_ref(lsurv_arg__);
  const auto& event = to_ref(event_arg__);
  const auto& lp = to_ref(lp_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 179;
    n = num_elements(lpdf);
    current_statement__ = 180;
    validate_non_negative_index("lht", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> lht;
    lht = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(lht, DUMMY_VAR__);
    
    current_statement__ = 181;
    assign(lht, nil_index_list(), subtract(lpdf, lsurv),
      "assigning variable lht");
    current_statement__ = 182;
    validate_non_negative_index("Ht", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> Ht;
    Ht = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(Ht, DUMMY_VAR__);
    
    current_statement__ = 183;
    assign(Ht, nil_index_list(), minus(lsurv), "assigning variable Ht");
    current_statement__ = 184;
    validate_non_negative_index("aux", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> aux;
    aux = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(aux, DUMMY_VAR__);
    
    current_statement__ = 185;
    assign(aux, nil_index_list(),
      elt_multiply(stan::math::exp(lp), stan::math::expm1(Ht)),
      "assigning variable aux");
    current_statement__ = 186;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 187;
    assign(loglik, nil_index_list(),
      subtract(
        elt_multiply(event,
          subtract(add(add(lht, lp), Ht), stan::math::log(tau))),
        elt_multiply(add(1, event), stan::math::log1p(aux))),
      "assigning variable loglik");
    current_statement__ = 188;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglik_po_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
T4__>, -1, 1>
operator()(const T0__& lpdf, const T1__& lsurv, const T2__& event,
           const T3__& lp, const T4__& tau, std::ostream* pstream__)  const 
{
return loglik_po(lpdf, lsurv, event, lp, tau, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__, typename T6__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
T6__>>, -1, 1>
loglik_yp(const T0__& status_arg__, const T1__& lpdf_arg__,
          const T2__& lsurv_arg__, const T3__& lp_short_arg__,
          const T4__& lp_long_arg__, const T5__& ratio_arg__,
          const T6__& tau, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T1__>,
          stan::value_type_t<T2__>,
          stan::value_type_t<T3__>,
          stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
          T6__>>;
  const auto& status = to_ref(status_arg__);
  const auto& lpdf = to_ref(lpdf_arg__);
  const auto& lsurv = to_ref(lsurv_arg__);
  const auto& lp_short = to_ref(lp_short_arg__);
  const auto& lp_long = to_ref(lp_long_arg__);
  const auto& ratio = to_ref(ratio_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int n;
    n = std::numeric_limits<int>::min();
    
    current_statement__ = 190;
    n = num_elements(lpdf);
    current_statement__ = 191;
    validate_non_negative_index("Rt0", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> Rt0;
    Rt0 = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(Rt0, DUMMY_VAR__);
    
    current_statement__ = 193;
    validate_non_negative_index("log_ht", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_ht;
    log_ht = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(log_ht, DUMMY_VAR__);
    
    current_statement__ = 195;
    validate_non_negative_index("log_St", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> log_St;
    log_St = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(log_St, DUMMY_VAR__);
    
    current_statement__ = 197;
    validate_non_negative_index("loglik", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
    loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(loglik, DUMMY_VAR__);
    
    current_statement__ = 199;
    validate_non_negative_index("theta", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> theta;
    theta = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(theta, DUMMY_VAR__);
    
    current_statement__ = 201;
    validate_non_negative_index("aux", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> aux;
    aux = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(aux, DUMMY_VAR__);
    
    current_statement__ = 203;
    validate_non_negative_index("lht0", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> lht0;
    lht0 = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(lht0, DUMMY_VAR__);
    
    current_statement__ = 204;
    assign(lht0, nil_index_list(),
      subtract(subtract(lpdf, lsurv), stan::math::log(tau)),
      "assigning variable lht0");
    current_statement__ = 205;
    validate_non_negative_index("Ht0", "n", n);
    Eigen::Matrix<local_scalar_t__, -1, 1> Ht0;
    Ht0 = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
    stan::math::fill(Ht0, DUMMY_VAR__);
    
    current_statement__ = 206;
    assign(Ht0, nil_index_list(), minus(lsurv), "assigning variable Ht0");
    current_statement__ = 207;
    assign(Rt0, nil_index_list(), stan::math::expm1(Ht0),
      "assigning variable Rt0");
    current_statement__ = 208;
    assign(theta, nil_index_list(), stan::math::exp(lp_long),
      "assigning variable theta");
    current_statement__ = 209;
    assign(aux, nil_index_list(), elt_multiply(ratio, Rt0),
      "assigning variable aux");
    current_statement__ = 210;
    assign(log_ht, nil_index_list(),
      add(add(subtract(lp_short, stan::math::log1p(aux)), lht0), Ht0),
      "assigning variable log_ht");
    current_statement__ = 211;
    assign(log_St, nil_index_list(),
      elt_multiply(minus(theta), stan::math::log1p(aux)),
      "assigning variable log_St");
    current_statement__ = 212;
    assign(loglik, nil_index_list(),
      add(elt_multiply(status, log_ht), log_St), "assigning variable loglik");
    current_statement__ = 213;
    return loglik;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct loglik_yp_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__,
typename T4__, typename T5__, typename T6__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>, stan::value_type_t<T1__>,
stan::value_type_t<T2__>, stan::value_type_t<T3__>,
stan::value_type_t<T4__>, stan::promote_args_t<stan::value_type_t<T5__>,
T6__>>, -1, 1>
operator()(const T0__& status, const T1__& lpdf, const T2__& lsurv,
           const T3__& lp_short, const T4__& lp_long, const T5__& ratio,
           const T6__& tau, std::ostream* pstream__)  const 
{
return loglik_yp(status, lpdf, lsurv, lp_short, lp_long, ratio, tau,
         pstream__);
}
};
#include <stan_meta_header.hpp>
class model_survreg final : public model_base_crtp<model_survreg> {
private:
  int n;
  int p;
  Eigen::Matrix<double, -1, 1> time;
  Eigen::Matrix<double, -1, 1> event;
  Eigen::Matrix<double, -1, -1> X;
  double tau;
  int baseline;
  int survreg;
  int is_alpha;
  int is_gamma;
  int is_lambda;
  int is_mu;
  int is_sigma;
  int is_phi;
  Eigen::Matrix<double, -1, 1> zeros;
  int beta_1dim__;
  int phi_1dim__;
  int alpha_1dim__;
  int gamma_1dim__;
  int lambda_1dim__;
  int mu_1dim__;
  int sigma_1dim__;
 
public:
  ~model_survreg() { }
  
  inline std::string model_name() const final { return "model_survreg"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_survreg(stan::io::var_context& context__,
                unsigned int random_seed__ = 0,
                std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_survreg_namespace::model_survreg";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 87;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 87;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 88;
      context__.validate_dims("data initialization","p","int",
          context__.to_vec());
      p = std::numeric_limits<int>::min();
      
      current_statement__ = 88;
      p = context__.vals_i("p")[(1 - 1)];
      current_statement__ = 89;
      validate_non_negative_index("time", "n", n);
      current_statement__ = 90;
      context__.validate_dims("data initialization","time","double",
          context__.to_vec(n));
      time = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(time, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> time_flat__;
        current_statement__ = 90;
        assign(time_flat__, nil_index_list(), context__.vals_r("time"),
          "assigning variable time_flat__");
        current_statement__ = 90;
        pos__ = 1;
        current_statement__ = 90;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 90;
          assign(time, cons_list(index_uni(sym1__), nil_index_list()),
            time_flat__[(pos__ - 1)], "assigning variable time");
          current_statement__ = 90;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 91;
      validate_non_negative_index("event", "n", n);
      current_statement__ = 92;
      context__.validate_dims("data initialization","event","double",
          context__.to_vec(n));
      event = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(event, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> event_flat__;
        current_statement__ = 92;
        assign(event_flat__, nil_index_list(), context__.vals_r("event"),
          "assigning variable event_flat__");
        current_statement__ = 92;
        pos__ = 1;
        current_statement__ = 92;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 92;
          assign(event, cons_list(index_uni(sym1__), nil_index_list()),
            event_flat__[(pos__ - 1)], "assigning variable event");
          current_statement__ = 92;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 93;
      validate_non_negative_index("X", "p == 0 ? 0 : n",
                                  (logical_eq(p, 0) ? 0 : n));
      current_statement__ = 94;
      validate_non_negative_index("X", "p", p);
      current_statement__ = 95;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec((logical_eq(p, 0) ? 0 : n), p));
      X = Eigen::Matrix<double, -1, -1>((logical_eq(p, 0) ? 0 : n), p);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 95;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 95;
        pos__ = 1;
        current_statement__ = 95;
        for (int sym1__ = 1; sym1__ <= p; ++sym1__) {
          current_statement__ = 95;
          for (int sym2__ = 1; sym2__ <= (logical_eq(p, 0) ? 0 : n); ++sym2__) {
            current_statement__ = 95;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 95;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 96;
      context__.validate_dims("data initialization","tau","double",
          context__.to_vec());
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 96;
      tau = context__.vals_r("tau")[(1 - 1)];
      current_statement__ = 97;
      context__.validate_dims("data initialization","baseline","int",
          context__.to_vec());
      baseline = std::numeric_limits<int>::min();
      
      current_statement__ = 97;
      baseline = context__.vals_i("baseline")[(1 - 1)];
      current_statement__ = 98;
      context__.validate_dims("data initialization","survreg","int",
          context__.to_vec());
      survreg = std::numeric_limits<int>::min();
      
      current_statement__ = 98;
      survreg = context__.vals_i("survreg")[(1 - 1)];
      current_statement__ = 99;
      is_alpha = std::numeric_limits<int>::min();
      
      current_statement__ = 99;
      is_alpha = 0;
      current_statement__ = 100;
      is_gamma = std::numeric_limits<int>::min();
      
      current_statement__ = 100;
      is_gamma = 0;
      current_statement__ = 101;
      is_lambda = std::numeric_limits<int>::min();
      
      current_statement__ = 101;
      is_lambda = 0;
      current_statement__ = 102;
      is_mu = std::numeric_limits<int>::min();
      
      current_statement__ = 102;
      is_mu = 0;
      current_statement__ = 103;
      is_sigma = std::numeric_limits<int>::min();
      
      current_statement__ = 103;
      is_sigma = 0;
      current_statement__ = 104;
      is_phi = std::numeric_limits<int>::min();
      
      current_statement__ = 104;
      is_phi = 0;
      current_statement__ = 105;
      validate_non_negative_index("zeros", "p == 0 ? n : 0",
                                  (logical_eq(p, 0) ? n : 0));
      current_statement__ = 106;
      zeros = Eigen::Matrix<double, -1, 1>((logical_eq(p, 0) ? n : 0));
      stan::math::fill(zeros, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 111;
      if (logical_eq(p, 0)) {
        current_statement__ = 109;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 107;
          assign(zeros, cons_list(index_uni(i), nil_index_list()), 0,
            "assigning variable zeros");}
      } 
      current_statement__ = 130;
      if (logical_eq(baseline, 1)) {
        current_statement__ = 128;
        is_lambda = 1;
      } else {
        current_statement__ = 127;
        if (logical_eq(baseline, 2)) {
          current_statement__ = 124;
          is_alpha = 1;
          current_statement__ = 125;
          is_gamma = 1;
        } else {
          current_statement__ = 123;
          if (logical_eq(baseline, 3)) {
            current_statement__ = 120;
            is_mu = 1;
            current_statement__ = 121;
            is_sigma = 1;
          } else {
            current_statement__ = 119;
            if (logical_eq(baseline, 4)) {
              current_statement__ = 116;
              is_alpha = 1;
              current_statement__ = 117;
              is_gamma = 1;
            } else {
              current_statement__ = 115;
              if (logical_eq(baseline, 5)) {
                current_statement__ = 112;
                is_alpha = 1;
                current_statement__ = 113;
                is_gamma = 1;
              } 
            }
          }
        }
      }
      current_statement__ = 133;
      if (logical_eq(survreg, 5)) {
        current_statement__ = 131;
        is_phi = 1;
      } 
      current_statement__ = 134;
      beta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 134;
      beta_1dim__ = (logical_eq(p, 0) ? 0 : p);
      current_statement__ = 134;
      validate_non_negative_index("beta", "p == 0 ? 0 : p", beta_1dim__);
      current_statement__ = 135;
      phi_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 135;
      phi_1dim__ = (logical_eq(is_phi, 0) ? 0 : p);
      current_statement__ = 135;
      validate_non_negative_index("phi", "is_phi == 0 ? 0 : p", phi_1dim__);
      current_statement__ = 136;
      alpha_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 136;
      alpha_1dim__ = (logical_eq(is_alpha, 0) ? 0 : 1);
      current_statement__ = 136;
      validate_non_negative_index("alpha", "is_alpha == 0 ? 0 : 1",
                                  alpha_1dim__);
      current_statement__ = 137;
      gamma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 137;
      gamma_1dim__ = (logical_eq(is_gamma, 0) ? 0 : 1);
      current_statement__ = 137;
      validate_non_negative_index("gamma", "is_gamma == 0 ? 0 : 1",
                                  gamma_1dim__);
      current_statement__ = 138;
      lambda_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 138;
      lambda_1dim__ = (logical_eq(is_lambda, 0) ? 0 : 1);
      current_statement__ = 138;
      validate_non_negative_index("lambda", "is_lambda == 0 ? 0 : 1",
                                  lambda_1dim__);
      current_statement__ = 139;
      mu_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 139;
      mu_1dim__ = (logical_eq(is_mu, 0) ? 0 : 1);
      current_statement__ = 139;
      validate_non_negative_index("mu", "is_mu == 0 ? 0 : 1", mu_1dim__);
      current_statement__ = 140;
      sigma_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 140;
      sigma_1dim__ = (logical_eq(is_sigma, 0) ? 0 : 1);
      current_statement__ = 140;
      validate_non_negative_index("sigma", "is_sigma == 0 ? 0 : 1",
                                  sigma_1dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += beta_1dim__;
      num_params_r__ += phi_1dim__;
      num_params_r__ += alpha_1dim__;
      num_params_r__ += gamma_1dim__;
      num_params_r__ += lambda_1dim__;
      num_params_r__ += mu_1dim__;
      num_params_r__ += sigma_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_survreg_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(beta_1dim__);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 1;
      beta = in__.vector(beta_1dim__);
      Eigen::Matrix<local_scalar_t__, -1, 1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, 1>(phi_1dim__);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 2;
      phi = in__.vector(phi_1dim__);
      std::vector<local_scalar_t__> alpha;
      alpha = std::vector<local_scalar_t__>(alpha_1dim__, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable alpha");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha[(sym1__ - 1)], 0, lp__),
            "assigning variable alpha");
        } else {
          current_statement__ = 3;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(alpha[(sym1__ - 1)], 0),
            "assigning variable alpha");
        }}
      std::vector<local_scalar_t__> gamma;
      gamma = std::vector<local_scalar_t__>(gamma_1dim__, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gamma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma[(sym1__ - 1)], 0, lp__),
            "assigning variable gamma");
        } else {
          current_statement__ = 4;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(gamma[(sym1__ - 1)], 0),
            "assigning variable gamma");
        }}
      std::vector<local_scalar_t__> lambda;
      lambda = std::vector<local_scalar_t__>(lambda_1dim__, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable lambda");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda[(sym1__ - 1)], 0, lp__),
            "assigning variable lambda");
        } else {
          current_statement__ = 5;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda[(sym1__ - 1)], 0),
            "assigning variable lambda");
        }}
      std::vector<local_scalar_t__> mu;
      mu = std::vector<local_scalar_t__>(mu_1dim__, DUMMY_VAR__);
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 6;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<local_scalar_t__> sigma;
      sigma = std::vector<local_scalar_t__>(sigma_1dim__, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 7;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      {
        current_statement__ = 8;
        validate_non_negative_index("lp", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> lp;
        lp = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(lp, DUMMY_VAR__);
        
        current_statement__ = 10;
        validate_non_negative_index("y", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> y;
        y = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(y, DUMMY_VAR__);
        
        current_statement__ = 12;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> loglik;
        loglik = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(loglik, DUMMY_VAR__);
        
        current_statement__ = 14;
        validate_non_negative_index("lpdf", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> lpdf;
        lpdf = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(lpdf, DUMMY_VAR__);
        
        current_statement__ = 16;
        validate_non_negative_index("lsurv", "n", n);
        Eigen::Matrix<local_scalar_t__, -1, 1> lsurv;
        lsurv = Eigen::Matrix<local_scalar_t__, -1, 1>(n);
        stan::math::fill(lsurv, DUMMY_VAR__);
        
        current_statement__ = 18;
        validate_non_negative_index("lp_long", "survreg == 5 ? n : 0",
                                    (logical_eq(survreg, 5) ? n : 0));
        Eigen::Matrix<local_scalar_t__, -1, 1> lp_long;
        lp_long = Eigen::Matrix<local_scalar_t__, -1, 1>((
                                                            logical_eq(
                                                              survreg, 5) ? n
                                                            : 0));
        stan::math::fill(lp_long, DUMMY_VAR__);
        
        current_statement__ = 20;
        validate_non_negative_index("ratio", "survreg == 5 ? n : 0",
                                    (logical_eq(survreg, 5) ? n : 0));
        Eigen::Matrix<local_scalar_t__, -1, 1> ratio;
        ratio = Eigen::Matrix<local_scalar_t__, -1, 1>((
                                                          logical_eq(survreg,
                                                            5) ? n : 0));
        stan::math::fill(ratio, DUMMY_VAR__);
        
        current_statement__ = 26;
        if (logical_gt(p, 0)) {
          current_statement__ = 24;
          assign(lp, nil_index_list(), multiply(X, beta),
            "assigning variable lp");
        } else {
          current_statement__ = 22;
          assign(lp, nil_index_list(), zeros, "assigning variable lp");
        }
        current_statement__ = 34;
        if (logical_eq(survreg, 1)) {
          current_statement__ = 32;
          assign(y, nil_index_list(), elt_divide(time, stan::math::exp(lp)),
            "assigning variable y");
        } else {
          current_statement__ = 31;
          if (logical_eq(survreg, 4)) {
            current_statement__ = 29;
            assign(y, nil_index_list(),
              elt_multiply(time, stan::math::exp(lp)), "assigning variable y");
          } else {
            current_statement__ = 27;
            assign(y, nil_index_list(), time, "assigning variable y");
          }
        }
        current_statement__ = 64;
        if (logical_eq(baseline, 1)) {
          current_statement__ = 62;
          for (int i = 1; i <= n; ++i) {
            current_statement__ = 59;
            assign(lpdf, cons_list(index_uni(i), nil_index_list()),
              exponential_lpdf<false>(y[(i - 1)], lambda),
              "assigning variable lpdf");
            current_statement__ = 60;
            assign(lsurv, cons_list(index_uni(i), nil_index_list()),
              exponential_lccdf(y[(i - 1)], lambda),
              "assigning variable lsurv");}
        } else {
          current_statement__ = 58;
          if (logical_eq(baseline, 2)) {
            current_statement__ = 56;
            for (int i = 1; i <= n; ++i) {
              current_statement__ = 53;
              assign(lpdf, cons_list(index_uni(i), nil_index_list()),
                weibull_lpdf<false>(y[(i - 1)], alpha, gamma),
                "assigning variable lpdf");
              current_statement__ = 54;
              assign(lsurv, cons_list(index_uni(i), nil_index_list()),
                weibull_lccdf(y[(i - 1)], alpha, gamma),
                "assigning variable lsurv");}
          } else {
            current_statement__ = 52;
            if (logical_eq(baseline, 3)) {
              current_statement__ = 50;
              for (int i = 1; i <= n; ++i) {
                current_statement__ = 47;
                assign(lpdf, cons_list(index_uni(i), nil_index_list()),
                  lognormal_lpdf<false>(y[(i - 1)], mu, sigma),
                  "assigning variable lpdf");
                current_statement__ = 48;
                assign(lsurv, cons_list(index_uni(i), nil_index_list()),
                  lognormal_lccdf(y[(i - 1)], mu, sigma),
                  "assigning variable lsurv");}
            } else {
              current_statement__ = 46;
              if (logical_eq(baseline, 4)) {
                current_statement__ = 44;
                for (int i = 1; i <= n; ++i) {
                  current_statement__ = 41;
                  assign(lpdf, cons_list(index_uni(i), nil_index_list()),
                    loglogistic2_lpdf<false>(y[(i - 1)], alpha[(1 - 1)],
                      gamma[(1 - 1)], pstream__), "assigning variable lpdf");
                  current_statement__ = 42;
                  assign(lsurv, cons_list(index_uni(i), nil_index_list()),
                    loglogistic2_lccdf(y[(i - 1)], alpha[(1 - 1)],
                      gamma[(1 - 1)], pstream__), "assigning variable lsurv");
                }
              } else {
                current_statement__ = 40;
                if (logical_eq(baseline, 5)) {
                  current_statement__ = 38;
                  for (int i = 1; i <= n; ++i) {
                    current_statement__ = 35;
                    assign(lpdf, cons_list(index_uni(i), nil_index_list()),
                      fatigue_lpdf<false>(y[(i - 1)], alpha[(1 - 1)],
                        gamma[(1 - 1)], pstream__), "assigning variable lpdf");
                    current_statement__ = 36;
                    assign(lsurv, cons_list(index_uni(i), nil_index_list()),
                      fatigue_lccdf(y[(i - 1)], alpha[(1 - 1)],
                        gamma[(1 - 1)], pstream__),
                      "assigning variable lsurv");}
                } 
              }
            }
          }
        }
        current_statement__ = 85;
        if (logical_eq(survreg, 1)) {
          current_statement__ = 83;
          assign(loglik, nil_index_list(),
            loglik_aft(lpdf, lsurv, event, lp, tau, pstream__),
            "assigning variable loglik");
        } else {
          current_statement__ = 82;
          if (logical_eq(survreg, 2)) {
            current_statement__ = 80;
            assign(loglik, nil_index_list(),
              loglik_ph(lpdf, lsurv, event, lp, tau, pstream__),
              "assigning variable loglik");
          } else {
            current_statement__ = 79;
            if (logical_eq(survreg, 3)) {
              current_statement__ = 77;
              assign(loglik, nil_index_list(),
                loglik_po(lpdf, lsurv, event, lp, tau, pstream__),
                "assigning variable loglik");
            } else {
              current_statement__ = 76;
              if (logical_eq(survreg, 4)) {
                current_statement__ = 74;
                assign(loglik, nil_index_list(),
                  loglik_ah(lpdf, lsurv, event, lp, tau, pstream__),
                  "assigning variable loglik");
              } else {
                current_statement__ = 71;
                if (logical_gt(p, 0)) {
                  current_statement__ = 68;
                  assign(lp_long, nil_index_list(), multiply(X, phi),
                    "assigning variable lp_long");
                  current_statement__ = 69;
                  assign(ratio, nil_index_list(),
                    stan::math::exp(multiply(X, subtract(beta, phi))),
                    "assigning variable ratio");
                } else {
                  current_statement__ = 65;
                  assign(lp_long, nil_index_list(), zeros,
                    "assigning variable lp_long");
                  current_statement__ = 66;
                  assign(ratio, nil_index_list(), stan::math::exp(zeros),
                    "assigning variable ratio");
                }
                current_statement__ = 72;
                assign(loglik, nil_index_list(),
                  loglik_yp(event, lpdf, lsurv, lp, lp_long, ratio,
                    tau, pstream__), "assigning variable loglik");
              }
            }
          }
        }
        current_statement__ = 86;
        lp_accum__.add(sum(loglik));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_survreg_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(beta_1dim__);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      beta = in__.vector(beta_1dim__);
      Eigen::Matrix<double, -1, 1> phi;
      phi = Eigen::Matrix<double, -1, 1>(phi_1dim__);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      phi = in__.vector(phi_1dim__);
      std::vector<double> alpha;
      alpha = std::vector<double>(alpha_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable alpha");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(alpha[(sym1__ - 1)], 0),
          "assigning variable alpha");}
      std::vector<double> gamma;
      gamma = std::vector<double>(gamma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gamma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(gamma[(sym1__ - 1)], 0),
          "assigning variable gamma");}
      std::vector<double> lambda;
      lambda = std::vector<double>(lambda_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable lambda");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(lambda[(sym1__ - 1)], 0),
          "assigning variable lambda");}
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 6;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable mu");}
      std::vector<double> sigma;
      sigma = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= phi_1dim__; ++sym1__) {
        vars__.emplace_back(phi[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        vars__.emplace_back(lambda[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(beta_1dim__);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 1;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
          current_statement__ = 1;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> phi;
      phi = Eigen::Matrix<double, -1, 1>(phi_1dim__);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 2;
        assign(phi_flat__, nil_index_list(), context__.vals_r("phi"),
          "assigning variable phi_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= phi_1dim__; ++sym1__) {
          current_statement__ = 2;
          assign(phi, cons_list(index_uni(sym1__), nil_index_list()),
            phi_flat__[(pos__ - 1)], "assigning variable phi");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      std::vector<double> alpha;
      alpha = std::vector<double>(alpha_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(alpha, nil_index_list(), context__.vals_r("alpha"),
        "assigning variable alpha");
      std::vector<double> alpha_free__;
      alpha_free__ = std::vector<double>(alpha_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(alpha_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(alpha[(sym1__ - 1)], 0),
          "assigning variable alpha_free__");}
      std::vector<double> gamma;
      gamma = std::vector<double>(gamma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(gamma, nil_index_list(), context__.vals_r("gamma"),
        "assigning variable gamma");
      std::vector<double> gamma_free__;
      gamma_free__ = std::vector<double>(gamma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(gamma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(gamma[(sym1__ - 1)], 0),
          "assigning variable gamma_free__");}
      std::vector<double> lambda;
      lambda = std::vector<double>(lambda_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(lambda, nil_index_list(), context__.vals_r("lambda"),
        "assigning variable lambda");
      std::vector<double> lambda_free__;
      lambda_free__ = std::vector<double>(lambda_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        current_statement__ = 5;
        assign(lambda_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(lambda[(sym1__ - 1)], 0),
          "assigning variable lambda_free__");}
      std::vector<double> mu;
      mu = std::vector<double>(mu_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      assign(mu, nil_index_list(), context__.vals_r("mu"),
        "assigning variable mu");
      std::vector<double> sigma;
      sigma = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      assign(sigma, nil_index_list(), context__.vals_r("sigma"),
        "assigning variable sigma");
      std::vector<double> sigma_free__;
      sigma_free__ = std::vector<double>(sigma_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        current_statement__ = 7;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= phi_1dim__; ++sym1__) {
        vars__.emplace_back(phi[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
        vars__.emplace_back(alpha_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
        vars__.emplace_back(gamma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
        vars__.emplace_back(lambda_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta");
    names__.emplace_back("phi");
    names__.emplace_back("alpha");
    names__.emplace_back("gamma");
    names__.emplace_back("lambda");
    names__.emplace_back("mu");
    names__.emplace_back("sigma");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(beta_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(phi_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(alpha_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(lambda_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(sigma_1dim__)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= phi_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= beta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= phi_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= alpha_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= lambda_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= sigma_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << beta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" << phi_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << alpha_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"array\",\"length\":" << gamma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"array\",\"length\":" << lambda_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << beta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"vector\",\"length\":" << phi_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << alpha_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"array\",\"length\":" << gamma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"array\",\"length\":" << lambda_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << sigma_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_survreg_namespace::model_survreg;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_survreg_namespace::profiles__;
}
#endif
#endif
