% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM.R
\name{KM}
\alias{KM}
\title{Kaplan-Meier product-limit estimate of survival}
\usage{
KM(time, status, t)
}
\arguments{
\item{time}{Survival time of the process.}

\item{status}{Censoring indicator of the survival time of the process; 0 if 
the survival time is  censored and 1 otherwise.}

\item{t}{The time for obtaining survival estimates.}
}
\value{
Vector with Kaplan-Meier estimate of survival.
}
\description{
This function provides survival estimates using the product-limit
Kaplan-Meier estimator.
}
\examples{
require(survival)
data("bladder4state")

obj<- multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
              gap2=bladder4state$y2, status=bladder4state$d2, 
              size=bladder4state$size) 
              
obj2<-obj[[1]]
KM(time = obj2$time, status = obj2$status, t = 20)
fit <- survfit(Surv(obj2$time, obj2$status) ~ 1, data = obj2)
summary(fit, time = 20)$surv

}
\references{
E. Kaplan and P. Meier. Nonparametric estimation from incomplete 
observations. Journal of the American Statistical Association, 53:457-481, 
1958.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
