% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{transform_to_stepfunction}
\alias{transform_to_stepfunction}
\title{Transform Fixed Point Prediction into a Stepfunction}
\usage{
transform_to_stepfunction(
  predict_function,
  eval_times = NULL,
  ...,
  type = NULL,
  prediction_element = NULL,
  times_element = NULL
)
}
\arguments{
\item{predict_function}{a function making the prediction based on \code{model} and \code{newdata} arguments, the \code{...} parameter is also passed to this function. It has to return either a numeric vector of the same length as \code{eval_times}, a matrix with this number of columns and the same number of rows as \code{nrow(newdata)}. It can also return a list, with one of the elements containing such an object.}

\item{eval_times}{a numeric vector of times, at which the fixed predictions are made. This can be \code{NULL}, if \code{predict_function} returns a list which contains such a vector.}

\item{...}{other parameters passed to predict_function}

\item{type}{the type of function to be returned, either \code{"survival"}, \code{"chf"} or \code{NULL} this chooses the value of the step function before the first prediction time. If \code{"survival"} then it is 1, if \code{"chf"} then 0, otherwise, it is the value of the prediction for the first time in numerical order.}

\item{prediction_element}{if \code{predict_function} returns a list with the matrix as one of its elements, this parameter should contain the name of this element}

\item{times_element}{if \code{predict_function} returns a list with the matrix as one of its elements, this parameter should contain the name of this element}
}
\value{
The function returns a function with three arguments, (\code{model}, \code{newdata}, \code{times}), ready to supply it to an explainer.
}
\description{
Some models return the survival function or cumulative hazard function prediction at the times of events present in the training data set. This is a convenient utility to allow the prediction to be evaluated at any time.
}
\examples{
\donttest{
library(survex)
library(survival)

rsf_src <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)

chf_function <- transform_to_stepfunction(predict,
    type = "chf",
    prediction_element = "chf",
    times_element = "time.interest"
)

explainer <- explain(rsf_src, predict_cumulative_hazard_function = chf_function)
}
}
