% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parts.R
\name{model_parts}
\alias{model_parts}
\alias{model_parts.surv_explainer}
\title{Dataset Level Variable Importance for Survival Models}
\usage{
model_parts(explainer, ...)

\method{model_parts}{surv_explainer}(
  explainer,
  loss_function = survex::loss_brier_score,
  ...,
  type = "raw",
  output_type = "survival",
  N = 1000
)
}
\arguments{
\item{explainer}{a model to be explained, preprocessed by the \code{explain()} function}

\item{...}{
  Arguments passed on to \code{\link[=surv_feature_importance]{surv_feature_importance}}, \code{\link[=surv_integrated_feature_importance]{surv_integrated_feature_importance}}
  \describe{
    \item{\code{B}}{numeric, number of permutations to be calculated}
    \item{\code{variables}}{a character vector, names of variables to be included in the calculation}
    \item{\code{variable_groups}}{a list of character vectors of names of explanatory variables. For each vector, a single variable-importance measure is computed for the joint effect of the variables which names are provided in the vector. By default, variable_groups = NULL, in which case variable-importance measures are computed separately for all variables indicated in the variables argument}
    \item{\code{label}}{label of the model, if provides overrides x$label}
  }}

\item{loss_function}{a function that will be used to assess variable importance, by default \code{loss_brier_score} for survival models. The function can be supplied manually but has to have these named parameters (\code{y_true}, \code{risk}, \code{surv}, \code{times}), where \code{y_true} represents the \code{survival::Surv} object with observed times and statuses, \code{risk} is the risk score calculated by the model, and \code{surv} is the survival function for each observation evaluated at \code{times}.}

\item{type}{a character vector, if \code{"raw"} the results are losses after the permutation, if \code{"ratio"} the results are in the form \code{loss/loss_full_model} and if \code{"difference"} the results are of the form \code{loss - loss_full_model}}

\item{output_type}{either \code{"survival"} or \code{"risk"} the type of survival model output that should be used for explanations. If \code{"survival"} the explanations are based on the survival function. Otherwise the scalar risk predictions are used by the \code{DALEX::model_profile} function.}

\item{N}{number of observations that should be sampled for calculation of variable importance. If \code{NULL} then variable importance will be calculated on the whole dataset.}
}
\value{
An object of class \code{c("model_parts_survival", "surv_feature_importance")}. It's a list with the explanations in the \code{result} element
}
\description{
This function calculates variable importance as change in the loss function after variable permutations.
}
\details{
\emph{Note}: This function can be run within \code{progressr::with_progress()} to display a progress bar, as the execution can take long, especially on large datasets.
}
\examples{
\donttest{
library(survival)
library(survex)

cph <- coxph(Surv(time, status) ~ ., data = veteran, model = TRUE, x = TRUE, y = TRUE)
rsf_ranger <- ranger::ranger(Surv(time, status) ~ .,
  data = veteran,
  respect.unordered.factors = TRUE,
  num.trees = 100,
  mtry = 3,
  max.depth = 5
)

cph_exp <- explain(cph)

rsf_ranger_exp <- explain(rsf_ranger,
  data = veteran[, -c(3, 4)],
  y = Surv(veteran$time, veteran$status)
)

cph_model_parts_brier <- model_parts(cph_exp)
print(head(cph_model_parts_brier$result))
plot(cph_model_parts_brier)


rsf_ranger_model_parts <- model_parts(rsf_ranger_exp)
print(head(rsf_ranger_model_parts$result))
plot(cph_model_parts_brier, rsf_ranger_model_parts)
}

}
