% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_summclust.R
\name{summary.summclust}
\alias{summary.summclust}
\title{A \code{summary()} method for objects of type \code{summclust}}
\usage{
\method{summary}{summclust}(object, ...)
}
\arguments{
\item{object}{An object of type summclust}

\item{...}{misc arguments}
}
\value{
The function \code{summary.summclust} returns a range of
cluster leverage statistics based on an object of type \code{summclust}
}
\description{
A \code{summary()} method for objects of type \code{summclust}
}
\examples{
\donttest{
if(requireNamespace("summclust") && requireNamespace("haven")){
library(summclust)
library(haven)

nlswork <- read_dta("http://www.stata-press.com/data/r9/nlswork.dta")
# drop NAs at the moment
nlswork <- nlswork[, c("ln_wage", "grade", "age", "birth_yr", "union", "race", "msp", "ind_code")]
nlswork <- na.omit(nlswork)

lm_fit <- lm(
  ln_wage ~ union +  race + msp + as.factor(birth_yr) + as.factor(age) + as.factor(grade),
  data = nlswork)

res <- summclust(
   obj = lm_fit,
   params = c("msp", "union"),
   cluster = ~ind_code,
 )

 summary(res)
}
}

}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
