% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_risk.R
\name{calc_risk}
\alias{calc_risk}
\title{Calculate the Cox Proportional hazards relative risk associated
with the covariates of subjects}
\usage{
calc_risk(data, coxphmod = NULL)
}
\arguments{
\item{data}{A data frame containing the covariates to be used
for risk-adjustment as named columns.}

\item{coxphmod}{(optional): A cox proportional hazards model generated using
\code{\link[survival:coxph]{coxph()}} or a list containing:
\describe{
\item{\code{formula}:}{a \code{\link[stats:formula]{formula()}} in the form \code{~ covariates};}
\item{\code{coefficients}:}{a named vector specifying risk adjustment coefficients
for covariates. Names must be the same as in \code{formula} and colnames of \code{data}.}
}}
}
\value{
A vector of \code{nrow(data)} specifying the increased/decreased
risk of failure for each subject.
}
\description{
This function can be used to calculate the change in the
relative risk of a subject pertaining to their covariates
under a specified Cox proportional hazards model.
}
\details{
The subject-specific relative risk is
\eqn{e^{\beta  Z_i}}{exp(\beta * Z_i)},
where \eqn{\beta}{\beta} is a vector of regression coefficients
and \eqn{Z_i}{Z_i} a vector of covariates for subject i.
}
\examples{
#Small example data
crdat <- data.frame(age = rnorm(10, 40, 5), BMI = rnorm(10, 24, 3))
#Example risk-adjustment list (can also specify coxphmod)
crlist <- list(formula = as.formula("~age + BMI"), coefficients = c("age"= 0.02, "BMI"= 0.009))
#Calculate the increase or decrease of the relative risk for the subjects
#in crdat.
calc_risk(crdat, crlist)
}
\author{
Daniel Gomon
}
