/**
 * [SubspaceClusteringEvalPanel.java] for Subspace MOA
 * 
 * Evaluation measure selection panel of "SubspaceClustering" tab - "Setup" subtab.
 * 
 * @author Yunsu Kim
 * 		   based on the implementation of Timm Jansen
 * Data Management and Data Exploration Group, RWTH Aachen University
 */

package moa.gui.subspaceclusteringtab;

import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.swing.JCheckBox;
import javax.swing.JLabel;

import moa.core.AutoClassDiscovery;
import moa.core.AutoExpandVector;
import moa.evaluation.SubspaceMeasureCollection;

public class SubspaceClusteringEvalPanel extends javax.swing.JPanel {

	private static final long serialVersionUID = 1L;

	Class<?>[] measure_classes = null;

    ArrayList<JLabel> labels = null;

    ArrayList<JCheckBox> checkboxes = null;

    /** Creates new form ClusteringEvalPanel */
    public SubspaceClusteringEvalPanel() {
        initComponents();
        measure_classes = findMeasureClasses();
        labels = new ArrayList<JLabel>();
        checkboxes = new ArrayList<JCheckBox>();
        addComponents();
    }

    private void addComponents() {
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new java.awt.Insets(2, 3, 2, 3);
        int counter = 0;
        for (int i = 0; i < measure_classes.length; i++) {
            try {
            	SubspaceMeasureCollection m = (SubspaceMeasureCollection) measure_classes[i].newInstance();
                for (int j = 0; j < m.getNumMeasures(); j++) {
                    JLabel l = new JLabel(m.getName(j));
                    l.setPreferredSize(new java.awt.Dimension(120, 14));
                    //labels[i].setToolTipText("");
                    gb.gridx = 0;
                    gb.gridy = counter;
                    labels.add(l);
                    contentPanel.add(l, gb);

                    JCheckBox cb = new JCheckBox();

                    if (m.isEnabled(j)) {
                        cb.setSelected(true);
                    } else {
                        cb.setSelected(false);
                    }

                    gb.gridx = 1;
                    checkboxes.add(cb);
                    contentPanel.add(cb, gb);
                    counter++;
                }
            } catch (Exception ex) {
                Logger.getLogger("Couldn't create Instance for " + measure_classes[i].getName());
                ex.printStackTrace();
            }

        }
        JLabel dummy = new JLabel();
        gb.gridx = 0;
        gb.gridy++;
        gb.gridwidth = 3;
        gb.weightx = 1;
        gb.weighty = 1;
        add(dummy, gb);
    }

    private Class<?>[] findMeasureClasses() {
        AutoExpandVector<Class<?>> classesToAppear = new AutoExpandVector<Class<?>>();
        Class<?>[] classesFound = AutoClassDiscovery.findClassesOfType("moa.evaluation", SubspaceMeasureCollection.class);
        for (Class<?> cl : classesFound) {
        	/* Specify unwanted evaluation measures */
            /*if (cl.getSimpleName().contains("CMM_S")) {
            	continue;
            } else {*/
                classesToAppear.add(cl);
            //}
        }
        return classesToAppear.toArray(new Class<?>[classesToAppear.size()]);
    }

    public SubspaceMeasureCollection[] getSelectedMeasures() {
        ArrayList<SubspaceMeasureCollection> measuresSelect = new ArrayList<SubspaceMeasureCollection>();

        int counter = 0;
        for (int i = 0; i < measure_classes.length; i++) {
            try {
                SubspaceMeasureCollection m = (SubspaceMeasureCollection) measure_classes[i].newInstance();
                boolean addMeasure = false;
                for (int j = 0; j < m.getNumMeasures(); j++) {
                    boolean selected = checkboxes.get(counter).isSelected();
                    m.setEnabled(j, selected);
                    if (selected) {
                        addMeasure = true;
                    }
                    counter++;
                }
                if (addMeasure) {
                    measuresSelect.add(m);
                }
            } catch (Exception ex) {
                Logger.getLogger("Couldn't create Instance for " + measure_classes[i].getName());
                ex.printStackTrace();
            }
        }


        SubspaceMeasureCollection[] measures = new SubspaceMeasureCollection[measuresSelect.size()];
        for (int i = 0; i < measures.length; i++) {
            measures[i] = measuresSelect.get(i);
        }
        return measures;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        scrollPane = new javax.swing.JScrollPane();
        contentPanel = new javax.swing.JPanel();

        setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Evaluation Measures", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 11))); // NOI18N
        setLayout(new java.awt.GridBagLayout());

        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        scrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
        scrollPane.setPreferredSize(new java.awt.Dimension(110, 225));
        scrollPane.setMinimumSize(new java.awt.Dimension(110, 225));

        contentPanel.setLayout(new java.awt.GridBagLayout());
        scrollPane.setViewportView(contentPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(scrollPane, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel contentPanel;
    private javax.swing.JScrollPane scrollPane;
    // End of variables declaration//GEN-END:variables
    
    public void setPanelTitle(String title) {
        setBorder(javax.swing.BorderFactory.createTitledBorder(null, title, javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
        													   javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 11)));
    }
}
