% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CTTsub.R
\name{CTTsub}
\alias{CTTsub}
\title{This main function computes subscores using different methods in classical test theory (CTT)}
\usage{
CTTsub(test.data)
}
\arguments{
\item{test.data}{A list that contains datasets of all subtests and the whole test,
which can be obtained using function 'data.prep'.}
}
\value{
A list of objects that include both test information and subscores: \cr
        (1) "subscore.information" - It contains test information of both subtests
                                     and the total test, such as mean of subscores and total score, reliability, and PRMSE.\cr
        (2) "subscore.original" - It contains original subscores and total score. \cr
        (3) "subscore.RegOnSub" - It contains subscores that are estimated based on the observed subscore. \cr
        (4) "subscore.RegOnTot" -It contains subscores that are estimated based on observed total score.\cr
        (5) "subscore.RegOnTotSub" - It containss subscores that are estimated based on both observed
                                    subscore and the observed total score.\cr
}
\description{
This function computes CTT subscores using methods introduced in
Haberman (2008), Haberman et al. (2009), and Sinharay (2010), which return:\cr
	(1) Original Observed subscore; \cr
	(2) The true subscore is estimated based on the observed subscore;\cr
	(3) The true subscore is estimated based on the observed  total score;\cr
	(4) The true subscore is estimated based on
	    both the observed subscore and the observed  total score.\cr
}
\examples{
CTTsub(test.data)
}

