% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subniche.R
\name{subniche}
\alias{margvect}
\alias{plot.subniche}
\alias{print.subniche}
\alias{refparam}
\alias{rtest.subniche}
\alias{rtestrefor}
\alias{rtestsubor}
\alias{subniche}
\alias{subparam.refor}
\alias{subparam.subor}
\alias{subplot}
\alias{summary.subniche}
\title{The Within Outlying Mean Index analysis}
\usage{
subniche(nic, factor)

\method{print}{subniche}(x, ...)

\method{plot}{subniche}(x, xax = 1, yax = 2, ...)

margvect(x, xax = 1, yax = 2, ...)

subplot(x, xax = 1, yax = 2, ...)

\method{summary}{subniche}(object, ...)

refparam(x)

\method{rtest}{subniche}(xtest, nrepet = 99, ...)

subparam.refor(x)

rtestrefor(x, nrepet)

subparam.subor(x)

rtestsubor(x, nrepet)
}
\arguments{
\item{nic}{an object of class \code{niche}.}

\item{factor}{a factor which will defined the subscales within which the subniches will be calculated (the same length of the number of sites)}

\item{x}{an object of class \code{subniche}.}

\item{...}{further arguments passed to or from other methods}

\item{xax}{specify the x column in your matrix}

\item{yax}{specify the y column in your matrix}

\item{object}{an object of class \code{subniche}.}

\item{xtest}{an object of class \code{subniche}.}

\item{nrepet}{the number of permutations for the testing procedure}
}
\value{
Adds items in the niche list and changing the class into \code{subniche} containing:

\code{factor} the factor use to divide the environmental and species matrix into subscale.

\code{mav} a dataframe with the subscale origins, \emph{G'}.

\code{mus} a dataframe with the subscale species niche coordinates
}
\description{
The analysis allows to divide the reference niche, estimated from the \link[ade4]{niche} function in the \link{ade4} package into subniches defined by a factor, which creates the
subscales. See details for more information.
}
\details{
The Within Outlying Mean Index analysis is a statistical exploratory niche analysis which provides observation of niche shift and/or conservatism, of an entire community,at different subcales
(temporal ,spatial and/or finer biological organisation level), and comparable under the same environmental gradients. This hindcasting multivariate analysis is based on the OMI analysis (Doledec \emph{et al.} 2000) which is used as reference.
The niches refinement is inspired by the K-select (Calenge \emph{et al.} 2005) which emphasizes the limiting factors in habitat use in design II and III (Thomas and Taylor, 1990).The different estimations should help understand:

1. the environmental factors defining a species' reference niche, under on the full scale, within a community.

2. the environmental factors defining a species' subniches, under each subscales, within a community.

The subniches parameters can be calculated from both the reference origin,\emph{G}, which corresponds to the reference plan origin, and from \emph{G'}, which corresponds to the
suborigins. \emph{G} is the graphical representation of the mean environmental conditions encountered over the full scale of the data. \emph{G'} is the mean environmental conditions
encountered at a subscale defined by the factor. They are complementary has you can compare:

1. a single species' subniches to \emph{G}.

2. the community' subniches to \emph{G'} at a specific subscale.

 The subniches of a single species can only be compared to \emph{G} as it is the common origin to all subscales. Whereas \emph{G'} is only common to the species found within the
subscale. So comparing different subniches of one species, found within different subscales, is only relevant to \emph{G}. The community's subniches can be compared to both \emph{G}
and \emph{G'}, but \emph{G}, being the mean environmental conditions found within the full scale, will not express the specificity of the environmental conditions that the species
encountered at the subscale. \emph{G'}, being the mean environmental conditions of the subscale, will reflect the atypical value of the environmental condition, making the
comparison of the community's subniches parameters more relevant.
}
\examples{
library(ade4)
data(doubs)
dudi1 <- dudi.pca(doubs$env, scale = TRUE, scan = FALSE, nf = 3)
nic1 <- niche(dudi1, doubs$fish, scann = FALSE)
# number of sites
N <- dim(nic1$ls)[1]
#Create a factor which defines the subscales
fact <- factor(c(rep(1,N/2),rep(2,N/2)))
# nic1 will be use as reference and fact will be use to define the subniches environment
subnic1 <- subniche(nic1, fact)
# the following two functions do the same display, plot.refniche is adapted to subniche objects
plot(nic1)
plot(subnic1)
#Display the marginality vector of the suborigins and the species subniche
margvect(subnic1)
#Display the subset's chull, found within the overall environment's chull,
#and the corresponding species positions
subplot(subnic1)
# The following two functions do the same display, refparam is adapted to subniche objects
niche.param(nic1)
refparam(subnic1)
# The following two functions do the same display, rtest is adapted to subniche objects
rtest(nic1,10)
rtest(subnic1,10)
#Calculates the subniches' parameters from G with the corresponding rtest
subparam.refor(subnic1)
rtestrefor(subnic1,10)
#Calculates the subniches' parameters from G' with the corresponding rtest
subparam.subor(subnic1)
rtestsubor(subnic1,10)
}
\author{
Stephane Karasiewicz, \email{stephane.karasiewicz@wanadoo.fr}
}
\references{
Doledec S., Chessel D. and Gimaret C. (2000). Niche separation in community analysis: a new method. \emph{Ecology},\bold{81}, 2914-1927.

Calenge C., Dufour A.B. and Maillard D. (2005). K-select analysis: a new method to analyse habitat selection in radio-tracking studies. \emph{Ecological modelling}, \bold{186}, 143-153.

Thomas D.L., Taylor E.J., (1990). Study designs and tests for comparing resource use and availability.\emph{ J. Wildl. Manage.}, \bold{54}, 322-330.

Karasiewicz S.,Doledec S.and Lefebvre S. (submitted). Within Outlying Mean Index analysis: combining OMI and K-select analysis for the realized niche decomposition.
}
\seealso{
\link[ade4]{niche} \link[ade4]{niche.param}
}
\keyword{subniche}

