% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-files.R
\name{parse_transform_serialize_roxygen}
\alias{parse_transform_serialize_roxygen}
\title{Parse, transform and serialize roxygen comments}
\usage{
parse_transform_serialize_roxygen(text, transformers)
}
\description{
Splits \code{text} into roxygen code examples and non-roxygen code examples and
then maps over these examples by applying
\code{\link[=style_roxygen_code_example]{style_roxygen_code_example()}}.
}
\section{Hierarchy}{

Styling involves splitting roxygen example code into segments, and segments
into snippets. This describes the process for input of
\code{\link[=parse_transform_serialize_roxygen]{parse_transform_serialize_roxygen()}}:
\itemize{
\item Splitting code into roxygen example code and other code. Downstream,
we are only concerned about roxygen code. See
\code{\link[=parse_transform_serialize_roxygen]{parse_transform_serialize_roxygen()}}.
\item Every roxygen example code can have zero or more
dontrun / dontshow / donttest sequences. We next create segments of roxygen
code examples that contain at most one of these. See
\code{\link[=style_roxygen_code_example]{style_roxygen_code_example()}}.
\item We further split the segment that contains at most one dont* sequence into
snippets that are either don* or not. See
\code{\link[=style_roxygen_code_example_segment]{style_roxygen_code_example_segment()}}.
}

Finally, that we have roxygen code snippets that are either dont* or not,
we style them in \code{\link[=style_roxygen_example_snippet]{style_roxygen_example_snippet()}} using
\code{\link[=parse_transform_serialize_r]{parse_transform_serialize_r()}}.
}

\keyword{internal}
