% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strcoll.R
\name{strcoll}
\alias{strcoll}
\alias{\%x<\%}
\alias{\%x<=\%}
\alias{\%x==\%}
\alias{\%x!=\%}
\alias{\%x>\%}
\alias{\%x>=\%}
\title{Compare Strings}
\usage{
strcoll(
  e1,
  e2,
  locale = NULL,
  strength = 3L,
  alternate_shifted = FALSE,
  french = FALSE,
  uppercase_first = NA,
  case_level = FALSE,
  normalisation = FALSE,
  numeric = FALSE
)

e1 \%x<\% e2

e1 \%x<=\% e2

e1 \%x==\% e2

e1 \%x!=\% e2

e1 \%x>\% e2

e1 \%x>=\% e2
}
\arguments{
\item{e1, e2}{character vector whose corresponding elements are to be
compared}

\item{locale}{\code{NULL} or \code{""} for the default locale
(see \code{\link[stringi]{stri_locale_get}})
or a single string with a locale identifier,
see \code{\link[stringi]{stri_locale_list}}}

\item{strength}{see \code{\link[stringi]{stri_opts_collator}}}

\item{alternate_shifted}{see \code{\link[stringi]{stri_opts_collator}}}

\item{french}{see \code{\link[stringi]{stri_opts_collator}}}

\item{uppercase_first}{see \code{\link[stringi]{stri_opts_collator}}}

\item{case_level}{see \code{\link[stringi]{stri_opts_collator}}}

\item{normalisation}{see \code{\link[stringi]{stri_opts_collator}}}

\item{numeric}{see \code{\link[stringi]{stri_opts_collator}}}
}
\value{
\code{strcmp} returns an integer vector representing the comparison results:
if a string in \code{e1} is smaller than the corresponding string in
\code{e2}, the corresponding result will be equal to \code{-1}, and
\code{0} if they are canonically equivalent,
as well as \code{1} if the former is greater than the latter.

The binary operators call \code{strcoll} with default arguments and
return logical vectors.
}
\description{
These functions provide means to compare strings in any locale
using the Unicode collation algorithm.
}
\details{
These functions are fully vectorised with respect to both arguments.

For a locale-insensitive behaviour like that of
\code{strcmp} from the standard C library, call
\code{strcoll(e1, e2, locale="C", strength=4L, normalisation=FALSE)}.
However, some normalisation will still be performed.
}
\section{Differences from Base R}{

Replacements for base \link[base]{Comparison} operators
implemented with \code{\link[stringi]{stri_cmp}}.

\itemize{
\item collation in different locales is difficult and non-portable across
    platforms
    \bold{[fixed here -- using services provided by ICU]}
\item overloading \code{`<.character`} has no effect in R, because S3
    method dispatch is done internally with hard-coded support for
    character arguments. We could have replaced the generic \code{`<`}
    with the one that calls \code{\link[base]{UseMethod}}, but
    it feels like a too intrusive solution
    \bold{[fixed by introducing the \code{`\%x<\%`} operator]}
}
}

\examples{
# lexicographic vs. numeric sort
strcoll("100", c("1", "10", "11", "99", "100", "101", "1000"))
strcoll("100", c("1", "10", "11", "99", "100", "101", "1000"), numeric=TRUE)
strcoll("hladn\u00FD", "chladn\u00FD", locale="sk_SK")

}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{xtfrm}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
