% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.r
\name{str_detect}
\alias{str_detect}
\title{Detect the presence or absence of a pattern in a string.}
\usage{
str_detect(string, pattern)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

  The default interpretation is a regular expression, as described
  in \link[stringi]{stringi-search-regex}. Control options with
  \code{\link{regex}()}.

  Match a fixed string (i.e. by comparing only bytes), using
  \code{\link{fixed}(x)}. This is fast, but approximate. Generally,
  for matching human text, you'll want \code{\link{coll}(x)} which
  respects character matching rules for the specified locale.

  Match character, word, line and sentence boundaries with
  \code{\link{boundary}()}. An empty pattern, "", is equivalent to
  \code{boundary("character")}.}
}
\value{
A logical vector.
}
\description{
Vectorised over \code{string} and \code{pattern}.
}
\examples{
fruit <- c("apple", "banana", "pear", "pinapple")
str_detect(fruit, "a")
str_detect(fruit, "^a")
str_detect(fruit, "a$")
str_detect(fruit, "b")
str_detect(fruit, "[aeiou]")

# Also vectorised over pattern
str_detect("aecfg", letters)
}
\seealso{
\code{\link[stringi]{stri_detect}} which this function wraps,
  \code{\link{str_subset}} for a convenient wrapper around 
  \code{x[str_detect(x, pattern)]}
}
