% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_startsendswith_4.R
\name{stri_startswith}
\alias{stri_startswith}
\alias{stri_endswith}
\alias{stri_startswith_fixed}
\alias{stri_endswith_fixed}
\alias{stri_startswith_charclass}
\alias{stri_endswith_charclass}
\alias{stri_startswith_coll}
\alias{stri_endswith_coll}
\title{Determine if the Start or End of a String Matches a Pattern}
\usage{
stri_startswith(str, ..., fixed, coll, charclass)

stri_endswith(str, ..., fixed, coll, charclass)

stri_startswith_fixed(
  str,
  pattern,
  from = 1L,
  negate = FALSE,
  ...,
  opts_fixed = NULL
)

stri_endswith_fixed(
  str,
  pattern,
  to = -1L,
  negate = FALSE,
  ...,
  opts_fixed = NULL
)

stri_startswith_charclass(str, pattern, from = 1L, negate = FALSE)

stri_endswith_charclass(str, pattern, to = -1L, negate = FALSE)

stri_startswith_coll(
  str,
  pattern,
  from = 1L,
  negate = FALSE,
  ...,
  opts_collator = NULL
)

stri_endswith_coll(
  str,
  pattern,
  to = -1L,
  negate = FALSE,
  ...,
  opts_collator = NULL
)
}
\arguments{
\item{str}{character vector}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_fixed},
and so on.}

\item{pattern, fixed, coll, charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{from}{integer vector}

\item{negate}{single logical value; whether a no-match to a pattern
is rather of interest}

\item{to}{integer vector}

\item{opts_collator, opts_fixed}{a named list used to tune up
the search engine's settings; see \code{\link{stri_opts_collator}}
and \code{\link{stri_opts_fixed}}, respectively; \code{NULL}
for the defaults}
}
\value{
Each function returns a logical vector.
}
\description{
These functions check if a string starts or ends with a match
to a given pattern. Also, it is possible to check if there is a match
at a specific position.
}
\details{
Vectorized over \code{str}, \code{pattern},
and \code{from} or \code{to} (with recycling
of the elements in the shorter vector if necessary).

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

Argument \code{start} controls the start position in \code{str}
where there is a match to a \code{pattern}.
\code{to} gives the end position.

Indexes given by \code{from} or \code{to} are of course 1-based,
i.e., an index 1 denotes the first character
in a string. This gives a typical R look-and-feel.

For negative indexes in \code{from} or \code{to}, counting starts
at the end of the string. For instance, index -1 denotes the last code point
in the string.

If you wish to test for a pattern match at an arbitrary
position in \code{str}, use \code{\link{stri_detect}}.

\code{stri_startswith} and \code{stri_endswith} are convenience functions.
They call either \code{stri_*_fixed}, \code{stri_*_coll},
or \code{stri_*_charclass}, depending on the argument used.
Relying on these underlying functions directly will make your code run
slightly faster.

Note that testing for a pattern match at the start or end of a string
has not been implemented separately for regex patterns.
For that you may use the '\code{^}' and '\code{$}' meta-characters,
see \link{stringi-search-regex}.
}
\examples{
stri_startswith_charclass(' trim me! ', '\\\\p{WSpace}')
stri_startswith_fixed(c('a1', 'a2', 'b3', 'a4', 'c5'), 'a')
stri_detect_regex(c('a1', 'a2', 'b3', 'a4', 'c5'), '^a')
stri_startswith_fixed('ababa', 'ba')
stri_startswith_fixed('ababa', 'ba', from=2)
stri_startswith_coll(c('a1', 'A2', 'b3', 'A4', 'C5'), 'a', strength=1)
pat <- stri_paste('\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 ',
                  '\u0639\u0644\u064a\u0647 \u0648\u0633\u0644\u0645XYZ')
stri_endswith_coll('\ufdfa\ufdfa\ufdfaXYZ', pat, strength=1)

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other search_detect: 
\code{\link{about_search}},
\code{\link{stri_detect}()}
}
\concept{search_detect}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
