% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_detect_coll}
\alias{stri_detect_coll}
\title{Detect a Canonically Equivalent Pattern Match}
\usage{
stri_detect_coll(str, pattern, opts_collator = NULL)
}
\arguments{
\item{str}{character vector}

\item{pattern}{character vector}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings}
}
\value{
Returns a logical vector.
}
\description{
This function checks if there is at least one occurrence of a pattern
in a string.  This is a locale-sensitive text operation.
}
\details{
Vectorized over \code{str} and \code{pattern}.

See \link{stringi-search-coll} for more details on
locale-sensitive text searching in \pkg{stringi}.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.
}
\seealso{
Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other search_coll: \code{\link{stri_count_coll}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_coll}};
  \code{\link{stringi-search-coll}};
  \code{\link{stringi-search}}

Other search_detect: \code{\link{stri_detect_charclass}};
  \code{\link{stri_detect_fixed}};
  \code{\link{stri_detect_regex}};
  \code{\link{stri_detect}}; \code{\link{stringi-search}}
}

