% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elem.R
\name{str_paste_elems}
\alias{str_paste_elems}
\title{Extract single elements of a string and paste them together.}
\usage{
str_paste_elems(string, indices, sep = "")
}
\arguments{
\item{string}{A character vector.}

\item{indices}{A vector of integerish values. Negative indexing is allowed as
in \code{\link[stringr:str_sub]{stringr::str_sub()}}.}

\item{sep}{A string. The separator for pasting \code{string} elements together.}
}
\value{
A character vector.
}
\description{
This is a quick way around doing a call to \code{\link[=str_elems]{str_elems()}} followed by a call
of \code{apply(..., paste)}.
}
\details{
Elements that don't exist e.g. element 5 of \code{"abc"} are ignored.
}
\examples{
string <- c("abc", "def", "ghi", "vwxyz")
str_paste_elems(string, 1:2)
str_paste_elems(string, c(1, 2, 3, 4, -1))
str_paste_elems("abc", c(1, 5, 55, 43, 3))
}
\seealso{
Other single element extractors: \code{\link{str_elems}},
  \code{\link{str_elem}}
}
\concept{single element extractors}
