% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stremr-package.R
\docType{data}
\name{OdatDT_10K}
\alias{OdatDT_10K}
\title{An example of a dataset in long format with random monitoring process and no right censoring.}
\format{A data frame with 10,000 observations and variables:
\describe{
  \item{ID}{Unique subject identifier}
  \item{t}{Interger for current time period, range 0-16}
  \item{CVD}{Baseline confounder (time invariant)}
  \item{lastNat1}{Time since last monitoring event, set to 0 when N[t-1]=0 and then added one for each new period where N[t] is 0.}
  \item{highA1c}{Time-varying confounder}
  \item{TI}{Binary exposure variable}
  \item{C}{Administrative censoring indicator, always set to 0 unless the end of study is reached (t==16)}
  \item{N}{The random indicator of being monitored (having a visit), simulated as a Bernoulli RV with P(N(t)=1)=0.5}
  \item{Y.tplus1}{Indicator of the survival event at t}
  \item{gTI.dlow}{Counterfactual exposure under static intervention - always treat}
  \item{gTI.dhigh}{Counterfactual exposure under dynamic intervention - treat only when highA1c is above 1 and the subject is being monitored}
  \item{gPois3.yrly}{Poisson probability of counterfactual monitoring indicator being equal to 1}
  \item{gPois3.biyrly}{Poisson probability of counterfactual monitoring indicator being equal to 1}
  \item{gp05}{Bernoulli probability of counterfactual monitoring indicator being equal to 1}
}}
\usage{
data(OdatDT_10K)
}
\description{
Simulated dataset containing 10,000 i.i.d. observations organized in long format as person-time rows.
The binary exposure is \code{TI} and binary outcome is \code{Y.tplus1}. See /tests/
for R code that generated this data as well as R code that uses stremr to analyze this data.
}
\keyword{datasets}

