/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.AbstractGraphCanvas;
import moa.gui.visualization.GraphMultiCurve;
import moa.gui.visualization.ProcessGraphAxes;

public class ProcessGraphCanvas
extends AbstractGraphCanvas {
    private static final long serialVersionUID = 1L;
    private int[] processFrequencies;
    private int min_processFrequency = 10000;

    public ProcessGraphCanvas() {
        super(new ProcessGraphAxes(), new GraphMultiCurve());
    }

    public int getMinProcessFrequency() {
        return this.min_processFrequency;
    }

    public int[] getProcessFrequencies() {
        return this.processFrequencies;
    }

    public void setGraph(MeasureCollection[] measures, MeasureCollection[] measureStds, int[] processFrequencies, int min_processFrequency, Color[] colors) {
        this.measures = measures;
        this.processFrequencies = processFrequencies;
        this.min_processFrequency = min_processFrequency;
        ((ProcessGraphAxes)this.axesPanel).setProcessFrequency(min_processFrequency);
        ((GraphMultiCurve)this.plotPanel).setProcessFrequency(min_processFrequency);
        ((GraphMultiCurve)this.plotPanel).setGraph(measures, measureStds, processFrequencies, colors);
        this.updateCanvas(false);
    }

    @Override
    public double getMinXValue() {
        return 0.0;
    }

    @Override
    public double getMaxXValue() {
        int max = 0;
        for (int i = 0; i < this.measures.length; ++i) {
            if (this.measures[i].getNumberOfValues(this.measureSelected) <= max) continue;
            max = this.measures[i].getNumberOfValues(this.measureSelected);
        }
        return max;
    }

    @Override
    public void setSize() {
        this.setSize(this.getWidth(), (int)(this.baseHeight * this.y_resolution));
    }

    @Override
    public void setPreferredSize() {
        this.setPreferredSize(new Dimension((int)Math.max(this.getPreferredSize().getWidth(), (double)((int)(this.max_x_value * this.x_resolution) + 35)), this.getHeight()));
    }
}

