/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import com.github.javacliparser.FloatOption;
import moa.evaluation.BasicClassificationPerformanceEvaluator;

public class EWMAClassificationPerformanceEvaluator
extends BasicClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    public FloatOption alphaOption = new FloatOption("alpha", 'a', "Fading factor or exponential smoothing factor", 0.01);
    protected BasicClassificationPerformanceEvaluator.Estimator weightCorrect;

    @Override
    protected BasicClassificationPerformanceEvaluator.Estimator newEstimator() {
        return new EWMAEstimator(this.alphaOption.getValue());
    }

    public class EWMAEstimator
    implements BasicClassificationPerformanceEvaluator.Estimator {
        protected double alpha;
        protected double estimation;

        public EWMAEstimator(double a) {
            this.alpha = a;
            this.estimation = 0.0;
        }

        @Override
        public void add(double value) {
            this.estimation += this.alpha * (value - this.estimation);
        }

        @Override
        public double estimation() {
            return this.estimation;
        }
    }
}

