/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.core.FastVector;
import moa.evaluation.MeasureCollection;
import moa.evaluation.OutlierPerformance;
import moa.gui.TextViewerPanel;
import moa.gui.outliertab.OutlierSetupTab;
import moa.gui.outliertab.OutlierVisualEvalPanel;
import moa.gui.outliertab.OutlierVisualTab;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.OutlierEvent;
import moa.gui.visualization.StreamOutlierPanel;
import moa.gui.visualization.WekaExplorer;
import moa.streams.clustering.ClusterEvent;
import moa.streams.clustering.ClusterEventListener;
import moa.streams.clustering.ClusteringStream;
import moa.streams.clustering.FileStream;
import moa.streams.clustering.RandomRBFGeneratorEvents;

public class RunOutlierVisualizer
implements Runnable,
ActionListener,
ClusterEventListener {
    public static final int initialPauseInterval = 1000;
    private int m_wait_frequency = 100;
    private int m_drawOutliersInterval = 100;
    private int m_redrawInterval = 100;
    private int m_eventsInterval = 20;
    private int m_eventsDecay = 100;
    private int m_MeasureInterval = 1000;
    private static boolean bWork;
    private boolean bStop = false;
    private static int timestamp;
    private int m_pauseInterval;
    private boolean m_bWaitWinFull;
    private final ClusteringStream m_stream0;
    private int m_stream0_decayHorizon;
    private double m_stream0_decay_threshold;
    private double m_stream0_decay_rate;
    private static final int ALGORITHM_1 = 0;
    private static final int ALGORITHM_2 = 1;
    private static final int MAX_ALGORITHMS = 2;
    boolean bUseAlgorithm2 = false;
    public MyBaseOutlierDetector[] m_outlier = new MyBaseOutlierDetector[2];
    private MeasureCollection[][] m_measures = new MeasureCollection[2][];
    private StreamOutlierPanel[] m_streampanel = new StreamOutlierPanel[2];
    private TreeSet<OutlierEvent>[] eventBuffer = new TreeSet[2];
    private OutlierVisualEvalPanel m_evalPanel;
    private GraphCanvas m_graphcanvas;
    private OutlierVisualTab m_visualPanel;
    private LinkedList<DataPoint> pointBuffer0;
    int nProcessed;
    Long[] m_timePreObjSum = new Long[2];
    int m_timePreObjInterval = 100;
    private final TextViewerPanel m_logPanel;

    public RunOutlierVisualizer(OutlierVisualTab visualPanel, OutlierSetupTab outlierSetupTab) {
        this.m_outlier[0] = outlierSetupTab.getOutlierer0();
        this.m_outlier[0].prepareForUse();
        this.m_outlier[0].SetUserInfo(false, false, new LogPanelPrintMsg(), 2000);
        this.m_outlier[0].outlierNotifier = new MyOutlierNotifier(0);
        this.m_outlier[1] = outlierSetupTab.getOutlierer1();
        boolean bl = this.bUseAlgorithm2 = this.m_outlier[1] != null;
        if (this.bUseAlgorithm2) {
            this.m_outlier[1].prepareForUse();
            this.m_outlier[1].SetUserInfo(false, false, new LogPanelPrintMsg(), 2000);
            this.m_outlier[1].outlierNotifier = new MyOutlierNotifier(1);
        }
        this.m_visualPanel = visualPanel;
        this.m_streampanel[0] = visualPanel.getLeftStreamPanel();
        this.m_streampanel[0].setVisualizer(this);
        this.m_streampanel[0].setOutlierDetector(this.m_outlier[0]);
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1] = visualPanel.getRightStreamPanel();
            this.m_streampanel[1].setVisualizer(this);
            this.m_streampanel[1].setOutlierDetector(this.m_outlier[1]);
        }
        this.m_logPanel = outlierSetupTab.getLogPanel();
        this.m_graphcanvas = visualPanel.getGraphCanvas();
        this.m_evalPanel = visualPanel.getEvalPanel();
        this.m_stream0 = outlierSetupTab.getStream0();
        this.m_stream0_decayHorizon = this.m_stream0.getDecayHorizon();
        this.m_stream0_decay_threshold = this.m_stream0.getDecayThreshold();
        this.m_stream0_decay_rate = Math.log(1.0 / this.m_stream0_decay_threshold) / Math.log(2.0) / (double)this.m_stream0_decayHorizon;
        this.eventBuffer[0] = new TreeSet();
        this.eventBuffer[1] = new TreeSet();
        timestamp = 0;
        bWork = true;
        if (this.m_stream0 instanceof RandomRBFGeneratorEvents) {
            // empty if block
        }
        this.m_stream0.prepareForUse();
        this.m_logPanel.setText("");
        this.m_measures[0] = outlierSetupTab.getMeasures();
        this.m_measures[1] = outlierSetupTab.getMeasures();
        this.m_graphcanvas.setGraph(this.m_measures[0][0], this.m_measures[1][0], 0, 100);
        this.updateSettings();
        if (this.m_stream0 instanceof FileStream) {
            this.m_stream0.numAttsOption.setValue(this.m_stream0.numAttsOption.getValue() - 1);
        }
        int dims = this.m_stream0.numAttsOption.getValue();
        visualPanel.setDimensionComobBoxes(dims);
    }

    private void updateSettings() {
        this.m_pauseInterval = this.m_visualPanel.getPauseInterval();
        this.m_wait_frequency = this.m_visualPanel.GetSpeed();
        this.setPointsVisibility(this.m_visualPanel.getPointVisibility());
        this.setOutliersVisibility(this.m_visualPanel.getOutliersVisibility());
        this.m_bWaitWinFull = this.m_visualPanel.getWaitWinFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.nProcessed = 0;
        this.m_timePreObjSum[0] = 0L;
        this.m_timePreObjSum[1] = 0L;
        this.pointBuffer0 = new LinkedList();
        while (!this.bStop) {
            if (!bWork || this.CanPause()) {
                this.updateSettings();
                this.drawOutliers();
                this.showOutliers(true);
                this.m_streampanel[0].repaint();
                if (this.bUseAlgorithm2) {
                    this.m_streampanel[1].repaint();
                }
                this.work_pause();
                if (this.bStop) break;
                this.updateSettings();
                this.showOutliers(false);
                this.m_streampanel[0].setHighlightedOutlierPanel(null);
                if (this.bUseAlgorithm2) {
                    this.m_streampanel[1].setHighlightedOutlierPanel(null);
                }
            }
            RunOutlierVisualizer runOutlierVisualizer = this;
            synchronized (runOutlierVisualizer) {
                this.processData();
            }
        }
    }

    private void MeasuredProcessStreamObj(int idxAlgorithm, Instance newInst) {
        this.m_outlier[idxAlgorithm].processNewInstanceImpl(newInst);
        if (this.nProcessed % this.m_timePreObjInterval == 0) {
            this.UpdateTimePerObj(idxAlgorithm, this.m_outlier[idxAlgorithm].getTimePerObj());
        }
    }

    private void processData() {
        if (this.m_stream0.hasMoreInstances()) {
            ++this.nProcessed;
            if (++timestamp % 100 == 0) {
                this.m_visualPanel.setProcessedPointsCounter(timestamp);
            }
            Instance nextStreamObj0 = (Instance)this.m_stream0.nextInstance().getData();
            DataPoint point0 = new DataPoint(nextStreamObj0, timestamp);
            this.pointBuffer0.add(point0);
            while (this.pointBuffer0.size() > this.m_stream0_decayHorizon) {
                this.pointBuffer0.removeFirst();
            }
            this.MeasuredProcessStreamObj(0, nextStreamObj0);
            if (this.bUseAlgorithm2) {
                this.MeasuredProcessStreamObj(1, nextStreamObj0);
            }
            this.m_streampanel[0].drawPoint(point0, false, false);
            if (this.bUseAlgorithm2) {
                this.m_streampanel[1].drawPoint(point0, false, false);
            }
            if (this.nProcessed % this.m_redrawInterval == 0) {
                float f = this.m_stream0_decayHorizon <= this.m_redrawInterval ? 1.0f : (float)this.m_redrawInterval / (float)this.m_stream0_decayHorizon;
                this.m_streampanel[0].applyDrawDecay(f, false);
                if (this.bUseAlgorithm2) {
                    this.m_streampanel[1].applyDrawDecay(f, false);
                }
            }
            this.drawEvents();
            this.m_streampanel[0].RedrawPointLayer();
            if (this.bUseAlgorithm2) {
                this.m_streampanel[1].RedrawPointLayer();
            }
            if (this.CanPause()) {
                this.showOutliers(true);
                this.drawOutliers();
                this.m_visualPanel.toggleVisualizer(true);
            }
        } else {
            System.out.println("DONE");
            RunOutlierVisualizer.pause();
            return;
        }
        this.simulateVisualSpeed();
    }

    private void UpdateTimePerObj(int idxAlgorithm, double t) {
        double ms = t / 1000000.0;
        OutlierPerformance op = (OutlierPerformance)this.m_measures[idxAlgorithm][0];
        op.addTimePerObject(ms);
        this.m_graphcanvas.updateCanvas();
        this.m_logPanel.addText("Algorithm " + idxAlgorithm + ", process time per object (ms): " + String.format("%.3f", ms));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ShowStatistics() {
        RunOutlierVisualizer runOutlierVisualizer = this;
        synchronized (runOutlierVisualizer) {
            this.m_logPanel.addText(" ");
            this.m_logPanel.addText("Algorithm1 " + this.m_outlier[0].getStatistics());
            if (this.bUseAlgorithm2) {
                this.m_logPanel.addText("Algorithm2 " + this.m_outlier[1].getStatistics());
            }
        }
    }

    private boolean CanPause() {
        if (this.m_pauseInterval != 0) {
            return this.nProcessed % this.m_pauseInterval == 0;
        }
        return false;
    }

    private void simulateVisualSpeed() {
        int iMaxWaitFreq = 100;
        int iSleepMS = iMaxWaitFreq - this.m_wait_frequency;
        if (iSleepMS < 0) {
            iSleepMS = 0;
        }
        if (iSleepMS > iMaxWaitFreq) {
            iSleepMS = iMaxWaitFreq;
        }
        if (iSleepMS > 0) {
            this.Sleep(iSleepMS);
        }
    }

    private void updatePointsWeight() {
        for (DataPoint p : this.pointBuffer0) {
            p.updateWeight(timestamp, this.m_stream0_decay_rate);
        }
    }

    public void setWaitWinFull(boolean b) {
        this.m_bWaitWinFull = b;
    }

    private boolean CanShowOutliers() {
        return !this.m_bWaitWinFull || this.nProcessed >= this.m_stream0_decayHorizon;
    }

    private void drawOutliers() {
        this.drawOutliers(0);
        if (this.bUseAlgorithm2) {
            this.drawOutliers(1);
        }
    }

    private void drawOutliers(int idxAlgorithm) {
        Vector<MyBaseOutlierDetector.Outlier> outliers = this.m_outlier[idxAlgorithm].getOutliersResult();
        if (outliers != null && outliers.size() > 0 && this.CanShowOutliers()) {
            this.m_streampanel[idxAlgorithm].drawOutliers(outliers, Color.RED);
        }
    }

    private void deleteExpiredEvents(int idxAlgorithm) {
        boolean b = true;
        while (b) {
            b = false;
            if (this.eventBuffer[idxAlgorithm].size() <= 0) continue;
            OutlierEvent ev = this.eventBuffer[idxAlgorithm].first();
            if ((long)timestamp <= ev.timestamp + (long)this.m_eventsDecay) continue;
            this.eventBuffer[idxAlgorithm].remove(ev);
            b = true;
        }
    }

    private void drawEvents() {
        this.drawEvents(0);
        if (this.bUseAlgorithm2) {
            this.drawEvents(1);
        }
    }

    private void drawEvents(int idxAlgorithm) {
        this.m_streampanel[idxAlgorithm].clearEvents();
        this.deleteExpiredEvents(idxAlgorithm);
        if (this.CanShowOutliers()) {
            for (OutlierEvent ev : this.eventBuffer[idxAlgorithm]) {
                this.m_streampanel[idxAlgorithm].drawEvent(ev, false);
            }
        }
    }

    private void drawPoints() {
        this.drawPoints(0);
        if (this.bUseAlgorithm2) {
            this.drawPoints(1);
        }
    }

    private void drawPoints(int idxAlgorithm) {
        this.m_streampanel[idxAlgorithm].clearPoints();
        for (DataPoint point0 : this.pointBuffer0) {
            point0.updateWeight(timestamp, this.m_stream0_decay_rate);
            this.m_streampanel[idxAlgorithm].drawPoint(point0, true, false);
        }
        this.m_streampanel[idxAlgorithm].RedrawPointLayer();
    }

    private void showOutliers(boolean bShow) {
        this.showOutliers(0, bShow);
        if (this.bUseAlgorithm2) {
            this.showOutliers(1, bShow);
        }
    }

    private void showOutliers(int idxAlgorithm, boolean bShow) {
        if (!bWork && this.m_visualPanel.isEnabledDrawOutliers() && this.CanShowOutliers()) {
            this.m_streampanel[idxAlgorithm].setOutliersVisibility(bShow);
        } else {
            this.m_streampanel[idxAlgorithm].setOutliersVisibility(false);
        }
    }

    private void _redraw() {
        this.m_streampanel[0].clearPoints();
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1].clearPoints();
        }
        this.drawPoints();
        this.drawEvents();
        this.showOutliers(true);
        this.m_streampanel[0].repaint();
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1].repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        RunOutlierVisualizer runOutlierVisualizer = this;
        synchronized (runOutlierVisualizer) {
            this._redraw();
        }
    }

    private void _redrawOnResize() {
        this.m_streampanel[0].clearPoints();
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1].clearPoints();
        }
        this.drawPoints();
        this.drawEvents();
        this.showOutliers(true);
        this.drawOutliers();
        this.m_streampanel[0].repaint();
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1].repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawOnResize() {
        RunOutlierVisualizer runOutlierVisualizer = this;
        synchronized (runOutlierVisualizer) {
            this._redrawOnResize();
        }
    }

    public static int getCurrentTimestamp() {
        return timestamp;
    }

    private void work_pause() {
        while (!bWork && !this.bStop) {
            this.Sleep(200);
        }
    }

    private void Sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void pause() {
        bWork = false;
    }

    public static void resume() {
        bWork = true;
    }

    public void stop() {
        bWork = false;
        this.bStop = true;
        this.ShowStatistics();
    }

    public void setSpeed(int speed) {
        this.m_wait_frequency = speed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setPointsVisibility(boolean selected) {
        this.m_streampanel[0].setPointsVisibility(selected);
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1].setPointsVisibility(selected);
        }
    }

    public void setOutliersVisibility(boolean selected) {
        this.m_streampanel[0].setOutliersVisibility(selected);
        if (this.bUseAlgorithm2) {
            this.m_streampanel[1].setOutliersVisibility(selected);
        }
    }

    @Override
    public void changeCluster(ClusterEvent e) {
        System.out.println(e.getType() + ": " + e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportCSV(String filepath) {
        try (PrintWriter out = null;){
            if (!filepath.endsWith(".csv")) {
                filepath = filepath + ".csv";
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(filepath)));
            out.write("\n");
            out.close();
        }
    }

    public void weka() {
        try {
            Class.forName("weka.gui.Logger");
        }
        catch (Exception e) {
            this.m_logPanel.addText("Please add weka.jar to the classpath to use the Weka explorer.");
            return;
        }
        Clustering wekaClustering = null;
        if (wekaClustering == null || wekaClustering.size() == 0) {
            this.m_logPanel.addText("Empty Clustering");
            return;
        }
        int dims = wekaClustering.get(0).getCenter().length;
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (int i = 0; i < dims; ++i) {
            attributes.addElement(new Attribute("att" + i));
        }
        Instances instances = new Instances("trainset", attributes, 0);
        for (int c = 0; c < wekaClustering.size(); ++c) {
            Cluster cluster = wekaClustering.get(c);
            DenseInstance inst = new DenseInstance(cluster.getWeight(), cluster.getCenter());
            inst.setDataset(instances);
            instances.add(inst);
        }
        WekaExplorer explorer = new WekaExplorer(instances);
    }

    private class MyOutlierNotifier
    extends MyBaseOutlierDetector.OutlierNotifier {
        int idxAlgorithm;

        public MyOutlierNotifier(int idxAlgorithm) {
            this.idxAlgorithm = idxAlgorithm;
        }

        @Override
        public void OnOutlier(MyBaseOutlierDetector.Outlier outlier) {
            DataPoint point = new DataPoint(outlier.inst, (int)outlier.id);
            OutlierEvent oe = new OutlierEvent(point, true, new Long(timestamp));
            if (!RunOutlierVisualizer.this.eventBuffer[this.idxAlgorithm].add(oe)) {
                RunOutlierVisualizer.this.eventBuffer[this.idxAlgorithm].remove(oe);
                RunOutlierVisualizer.this.eventBuffer[this.idxAlgorithm].add(oe);
            }
        }

        @Override
        public void OnInlier(MyBaseOutlierDetector.Outlier outlier) {
            DataPoint point = new DataPoint(outlier.inst, (int)outlier.id);
            OutlierEvent oe = new OutlierEvent(point, false, new Long(timestamp));
            if (!RunOutlierVisualizer.this.eventBuffer[this.idxAlgorithm].add(oe)) {
                RunOutlierVisualizer.this.eventBuffer[this.idxAlgorithm].remove(oe);
                RunOutlierVisualizer.this.eventBuffer[this.idxAlgorithm].add(oe);
            }
        }
    }

    private class LogPanelPrintMsg
    implements MyBaseOutlierDetector.PrintMsg {
        private LogPanelPrintMsg() {
        }

        @Override
        public void println(String s) {
            RunOutlierVisualizer.this.m_logPanel.addText(s);
        }

        @Override
        public void print(String s) {
            RunOutlierVisualizer.this.m_logPanel.addText(s);
        }

        @Override
        public void printf(String fmt, Object ... args) {
            RunOutlierVisualizer.this.m_logPanel.addText(String.format(fmt, args));
        }
    }
}

