/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.meta;

import com.github.javacliparser.IntOption;
import com.github.javacliparser.Option;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.core.ObjectRepository;
import moa.evaluation.preview.PreviewCollection;
import moa.options.ClassOption;
import moa.streams.PartitioningStream;
import moa.tasks.TaskMonitor;
import moa.tasks.meta.ALMainTask;
import moa.tasks.meta.ALMultiParamTask;
import moa.tasks.meta.ALPrequentialEvaluationTask;
import moa.tasks.meta.ALTaskThread;

public class ALPartitionEvaluationTask
extends ALMainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption multiParamTaskOption = new ClassOption("multiParamTask", 't', "Multi param task to be performed for each partition", ALMultiParamTask.class, "moa.tasks.meta.ALMultiParamTask");
    public IntOption numPartitionsOption = new IntOption("numPartitions", 'k', "Number of data set partitions.", 10);
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "random seed which is used for partitioning of the stream.", 0);
    private ArrayList<ALTaskThread> subtaskThreads = new ArrayList();
    private ArrayList<ALTaskThread> flattenedSubtaskThreads = new ArrayList();

    @Override
    public String getPurposeString() {
        return "Evaluates an active learning classifier on a stream by partitioning the data stream and evaluating the classifier on each subset for each element of a set of parameter values using prequential evaluation (testing, then training with each example in sequence).";
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        super.prepareForUseImpl(monitor, repository);
        this.colorCoding = Color.WHITE;
        ALMultiParamTask multiParamTask = (ALMultiParamTask)this.multiParamTaskOption.getPreMaterializedObject();
        ALPrequentialEvaluationTask evalTask = (ALPrequentialEvaluationTask)multiParamTask.prequentialEvaluationTaskOption.getPreMaterializedObject();
        String baseStream = evalTask.streamOption.getValueAsCLIString();
        Random random = new Random(this.randomSeedOption.getValue());
        for (int i = 0; i < this.numPartitionsOption.getValue(); ++i) {
            PartitioningStream stream = new PartitioningStream();
            stream.streamOption.setValueViaCLIString(baseStream);
            stream.partitionIndexOption.setValue(i);
            stream.numPartitionsOption.setValue(this.numPartitionsOption.getValue());
            stream.randomSeedOption.setValue(random.nextInt());
            ALMultiParamTask partitionTask = (ALMultiParamTask)multiParamTask.copy();
            partitionTask.setIsLastSubtaskOnLevel(this.isLastSubtaskOnLevel, i == this.numPartitionsOption.getValue() - 1);
            partitionTask.setPartitionIdx(i);
            ALPrequentialEvaluationTask partitionEvalTask = (ALPrequentialEvaluationTask)partitionTask.prequentialEvaluationTaskOption.getPreMaterializedObject();
            partitionEvalTask.streamOption.setCurrentObject(stream);
            partitionTask.prepareForUse();
            List<ALTaskThread> childSubtasks = partitionTask.getSubtaskThreads();
            ALTaskThread subtaskThread = new ALTaskThread(partitionTask);
            this.subtaskThreads.add(subtaskThread);
            this.flattenedSubtaskThreads.add(subtaskThread);
            this.flattenedSubtaskThreads.addAll(childSubtasks);
        }
    }

    @Override
    public Class<?> getTaskResultType() {
        return PreviewCollection.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        ALMultiParamTask multiParamTask = (ALMultiParamTask)this.multiParamTaskOption.getPreMaterializedObject();
        Option[] variedParamValueOptions = multiParamTask.variedParamValuesOption.getList();
        int numVariedParams = variedParamValueOptions.length;
        double[] variedParamValues = new double[numVariedParams];
        for (int i = 0; i < numVariedParams; ++i) {
            variedParamValues[i] = Double.valueOf(variedParamValueOptions[i].getValueAsCLIString());
        }
        PreviewCollection<PreviewCollection> previewCollection = new PreviewCollection<PreviewCollection>("partition evaluation entry id", "partition id", this.getClass(), multiParamTask.variedParamNameOption.getValueAsCLIString(), variedParamValues);
        monitor.setCurrentActivity("Performing evaluation...", 50.0);
        monitor.setCurrentActivity("Performing evaluation...", -1.0);
        for (int i = 0; i < this.subtaskThreads.size(); ++i) {
            this.subtaskThreads.get(i).start();
        }
        int numSubtaskThreads = this.subtaskThreads.size();
        boolean allThreadsCompleted = false;
        while (!allThreadsCompleted) {
            allThreadsCompleted = true;
            int oldNumEntries = previewCollection.numEntries();
            double completionSum = 0.0;
            for (int i = 0; i < numSubtaskThreads; ++i) {
                ALTaskThread currentTaskThread = this.subtaskThreads.get(i);
                allThreadsCompleted &= currentTaskThread.isComplete();
                if (currentTaskThread.failed() || currentTaskThread.cancelled()) {
                    monitor.requestCancel();
                }
                completionSum += currentTaskThread.getCurrentActivityFracComplete();
                PreviewCollection latestPreview = (PreviewCollection)currentTaskThread.getLatestResultPreview();
                if (latestPreview != null && latestPreview.numEntries() > 0) {
                    previewCollection.setPreview(i, latestPreview);
                    continue;
                }
                if (!currentTaskThread.isComplete()) break;
                PreviewCollection finalPreview = (PreviewCollection)currentTaskThread.getFinalResult();
                previewCollection.setPreview(i, finalPreview);
            }
            double completionFraction = completionSum / (double)numSubtaskThreads;
            monitor.setCurrentActivityFractionComplete(completionFraction);
            if (monitor.taskShouldAbort()) {
                return null;
            }
            if (oldNumEntries >= previewCollection.numEntries() || !monitor.resultPreviewRequested() && !this.isSubtask()) continue;
            monitor.setLatestResultPreview(previewCollection.copy());
        }
        return previewCollection;
    }

    @Override
    public List<ALTaskThread> getSubtaskThreads() {
        return this.flattenedSubtaskThreads;
    }
}

