/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AnyOut;

import java.util.ArrayList;
import moa.clusterers.outliers.AnyOut.AnyOutCore;
import moa.clusterers.outliers.AnyOut.util.DataObject;
import moa.clusterers.outliers.AnyOut.util.DataSet;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.options.Options;
import weka.core.Instance;

public class AnyOut
extends MyBaseOutlierDetector {
    private static final long serialVersionUID = 1L;
    private final int FIRST_OBJ_ID = 0;
    private final double minDepth = 0.5;
    private final double maxDepth = 0.9;
    private AnyOutCore anyout = new AnyOutCore();
    private int idCounter;
    private int windowSize;
    private ArrayList<DataObject> objects;
    private DataSet trainingSet;
    private int trainingCount;
    private int trainingSetSize;
    private int truePositive;
    private int falsePositive;
    private int totalOutliers;
    private int outlierClass;

    public void resetLearningImpl() {
        this.anyout.resetLearning();
        super.resetLearningImpl();
    }

    protected void Init() {
        this.trainingCount = 0;
        this.truePositive = 0;
        this.falsePositive = 0;
        this.totalOutliers = 0;
        this.outlierClass = -1;
        this.trainingSetSize = this.anyout.trainingSetSizeOption.getValue();
        this.idCounter = 0;
        this.windowSize = this.anyout.horizonOption.getValue();
        this.objects = new ArrayList();
        super.Init();
    }

    protected void ProcessNewStreamObj(Instance i) {
        if (this.trainingSetSize >= this.trainingCount) {
            if (this.trainingSet == null) {
                this.trainingSet = new DataSet(i.numAttributes() - 1);
            }
            DataObject o = new DataObject(this.idCounter++, i);
            this.trainingSet.addObject(o);
            ++this.trainingCount;
        } else {
            if (this.trainingSetSize != -1) {
                this.anyout.train(this.trainingSet);
                this.trainingSet.clear();
                this.trainingSetSize = -1;
                this.outlierClass = i.classAttribute().numValues() - 1;
            }
            DataObject o = new DataObject(this.idCounter++, i);
            this.objects.add(o);
            if (o.getClassLabel() == this.outlierClass) {
                ++this.totalOutliers;
            }
            if (this.objects.size() > this.windowSize) {
                DataObject obj = this.objects.get(0);
                this.objects.remove(0);
                this.anyout.removeObject(obj.getId());
                this.RemoveExpiredOutlier(new MyBaseOutlierDetector.Outlier(obj.getInstance(), obj.getId(), obj));
            }
            this.anyout.initObject(o.getId(), o.getFeatures());
            double depth = Math.random();
            if (depth < 0.5) {
                depth = 0.5;
            } else if (depth > 0.9) {
                depth = 0.9;
            }
            while (this.anyout.moreImprovementsPossible(o.getId(), depth)) {
                this.anyout.improveObjectOnce(o.getId());
            }
            this.anyout.learnObject(o.getFeatures());
            for (DataObject obj : this.objects) {
                int id = obj.getId();
                if (this.anyout.isOutlier(id)) {
                    if (obj.isOutiler()) continue;
                    if (obj.getClassLabel() == this.outlierClass) {
                        ++this.truePositive;
                    } else {
                        ++this.falsePositive;
                    }
                    this.AddOutlier(new MyBaseOutlierDetector.Outlier(obj.getInstance(), id, obj));
                    obj.setOutiler(true);
                    continue;
                }
                this.RemoveOutlier(new MyBaseOutlierDetector.Outlier(obj.getInstance(), id, obj));
                obj.setOutiler(false);
            }
        }
    }

    public String getPurposeString() {
        return "Anyout: Anytime Outlier Detector based on ClusTree";
    }

    public Options getOptions() {
        return this.anyout.getOptions();
    }

    private int getWindowEnd() {
        return this.idCounter - 1;
    }

    private int getWindowStart() {
        int x = this.getWindowEnd() - this.windowSize + 1;
        if (x < 0) {
            x = 0;
        }
        return x;
    }

    protected boolean IsNodeIdInWin(long id) {
        return (long)this.getWindowStart() <= id && id <= (long)this.getWindowEnd();
    }

    public String getObjectInfo(Object o) {
        DataObject obj = (DataObject)o;
        double[] features = obj.getFeatures();
        int id = obj.getId();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<table>");
        sb.append("<tr><td><b>ID:</b></td><td>" + id + "</td></tr>");
        sb.append("<tr><td><b>X, Y:</b></td><td>" + String.format("%.4f", features[0]) + ", " + String.format("%.4f", features[1]) + "</td></tr>");
        sb.append("<tr><td><b>Oscore:</b></td><td>" + String.format("%.4f", this.anyout.getOutlierScore(id)) + "</td></tr>");
        sb.append("<tr><td><b>Conf:</b></td><td>" + String.format("%.4f", this.anyout.getConfidence(id)) + "</td></tr>");
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    public String getStatistics() {
        StringBuilder sb = new StringBuilder();
        int sum = this.truePositive + this.falsePositive;
        sb.append("Statistics:\n\n");
        sb.append(String.format("  Outliers found: %d (%.1f%%)\n", sum, (double)(100 * sum) / (double)this.totalOutliers));
        sb.append(String.format("  True positive found: %d (%.1f%%)\n", this.truePositive, (double)(100 * this.truePositive) / (double)this.totalOutliers));
        sb.append(String.format("  False positive found: %d (%.1f%%)\n", this.falsePositive, (double)(100 * this.falsePositive) / (double)this.totalOutliers));
        sb.append("\n");
        sb.append("  Max memory usage: " + this.iMaxMemUsage + " MB\n");
        sb.append("  Total process time: " + String.format("%.2f ms", (double)this.nTotalRunTime.longValue() / 1000.0) + "\n");
        return sb.toString();
    }
}

