% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DST_Multi.R
\name{DST_Multi}
\alias{DST_Multi}
\title{Apply Multiple Task to the Same Data Stream}
\usage{
DST_Multi(dsts)
}
\arguments{
\item{dsts}{a list of \link{DST} objects.}
}
\description{
Apply multiple task (\link{DST}) to the same data stream. The tasks can be accessed
as a list as \verb{$dsts}.
}
\examples{
set.seed(1500)

stream <- DSD_Gaussians(k = 3, d = 2)

## define multiple tasks as a list
tasks <- DST_Multi(list(
   DSAggregate_Window(horizon = 10),
   DSC_DStream(gridsize = 0.1)
))
tasks

## update both tasks with the same stream
update(tasks, stream, n = 1000)

## inspect the results of the tasks
tasks$dsts[[1]]
get_model(tasks$dsts[[1]])

tasks$dsts[[2]]
plot(tasks$dsts[[2]])
}
\author{
Michael Hahsler
}
