\name{HRatio}
\alias{HRatio}
\title{
Estimate hazard ratio between two subjects
}
\description{
This function estimates the  hazard ratio between two subjects at given times, along with the associated 95\% confidence interval.
}
\usage{
HRatio(x, times, NumStra, NumZ=NULL, DemStra, DemZ=NULL)
}
\arguments{
  \item{x}{
results from the model fit returned by the icweib function.
}
  \item{times}{
the vector of times at which the hazard ratio is estimated.
}
  \item{NumStra}{
the strata of the subject in the numerator. If the model is unstratified, then set it to be the constant that is used for \emph{strata} argument in \emph{icweib} function, e.g. "ALL".
}
  \item{NumZ}{
the vector of values of the explanatory variables for the subject in the numerator. The order and length should match the estimated coefficients as shown in x$coef. The default is NULL, corresponding to all 0 or baseline. 	
}
  \item{DemStra}{
the strata of the subject in the denominator. If the model is unstratified, then set it to be the constant that is used for \emph{strata} argument in \emph{icweib} function, e.g. "ALL".
}
  \item{DemZ}{
the vector of values of the explanatory variables for the subject in the denominator. The order and length should match the estimated coefficients as shown in x$coef. The default is NULL, corresponding to all 0 or baseline.  	
}
}
\details{
The hazard ratio between two subjects is obtained from the maximum likelihood estimates from the stratified Weibull regression model, along with the corresponding 95\% confidence interval. 
}
\value{
A data frame of estimated hazard ratios and confidence intervals for two subjects at each time point is returned.
}

\author{
Xiangdong Gu and Raji Balasubramanian
}

\seealso{
\code{\link{icweib}}, \code{\link{plot}}
}
\examples{
data(tooth24)
fit <- icweib(L = left, R = right, data = tooth24, strata = dmf, covariates = ~sex)
HRatio(fit, times = 1:7, NumStra = 0, NumZ=0, DemStra = 1, DemZ=0)
}

