% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nopt.R
\name{sa0}
\alias{sa0}
\title{Sequential Allocation (ver. 0) Algorithm for Optimal Sample Allocation in Stratified Sampling Scheme}
\usage{
sa0(d, M, n, verbose = FALSE)
}
\arguments{
\item{d}{a numeric vector, equal to (element-wise) multiplication of strata sizes by standard deviations of a study variable in strata.}

\item{M}{a numeric vector, upper bounds constraints on sample sizes in strata. It must be that \code{0 < M <= N}, where \code{N - strata sizes}.}

\item{n}{integer, total sample size.}

\item{verbose}{logical, if \emph{TRUE}, more interim variables from chosen algorithm are returned; in particular: \code{J} - set of strata indices sorted
in non-increasing order of \code{\\frac{d}{M}}, \code{J_} - set of strata indices for which the allocated sample size is strictly less than its upper bound constraint \code{M}.}
}
\value{
Numeric vector with optimal sample allocations in strata, or
 list with numeric vector of optimal sample allocations in strata (1st element of the list), and corresponding interim variables (further elements of the list).
}
\description{
Implementation of the Sequential Allocation (ver. 0) algorithm for optimal sample allocation problem in
stratified sampling scheme with simple random sampling without replacement design in each stratum.
The algorithm is described in Wojciak (2019).
}
\examples{
N <- c(3000, 4000, 5000, 2000)
S <- rep(1, 4)
sa0(d = N * S, M = c(100, 90, 70, 80), n = 190)


}
\references{
Wojciak W. (2019) \emph{Optimal allocation in stratified sampling schemes}.
  Master's diploma thesis, Warsaw University of Technology. \url{http://home.elka.pw.edu.pl/~wwojciak/msc_optimal_allocation.pdf}
}
