% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfs.R
\name{sfs}
\alias{sfs}
\title{Site Frequency Spectrum}
\usage{
sfs(
  x,
  strata.col = 2,
  locus.col = 3,
  fsc.dimnames = TRUE,
  sort.strata = TRUE,
  na.action = c("fail", "filter")
)
}
\arguments{
\item{x}{a data frame of SNP genotypes where the first two columns are id and
strata designations and SNPs start on the third column. SNP genotypes are
coded as integers where 0 and 2 are the major and minor homozygotes and 1
is the heterozygote.}

\item{strata.col}{column number that strata designations are in.}

\item{locus.col}{column number that loci start in. All columns after this are
assumed to be loci.}

\item{fsc.dimnames}{format matrix dimnames for fastsimcoal2? If \code{TRUE},
then row and column names will be prefixed with the deme number (e.g.,
"d0_") that they represent.}

\item{sort.strata}{if \code{joint = TRUE}, are strata to be sorted
alphabetically? If \code{FALSE} then strata are taken in the order found in
\code{strata.col}.}

\item{na.action}{action to take if genotypes are missing for some samples. 
If \code{"fail"}, an error is thrown if any genotypes are missing. If 
\code{"filter"}, SNPs with missing genotypes are removed.}
}
\value{
A list of the marginal (1D) and joint (2D) site frequency spectra. 
  If only one stratum is present, then \code{$marginal} will be  \code{NULL}.
}
\description{
Calculate the SFS from a data frame of SNP genotypes
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
