% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGammaHaps.R
\name{simGammaHaps}
\alias{simGammaHaps}
\title{Simulate Haplotypes}
\usage{
simGammaHaps(pop.size, num.haps, shape, scale, return.freq = TRUE,
  plot = TRUE)
}
\arguments{
\item{pop.size}{size of population.}

\item{num.haps}{number of haplotypes to generate.}

\item{shape, scale}{parameters of Gamma distribution (see \code{\link{dgamma}}).}

\item{return.freq}{logical. Return frequency table of haplotypes? If \code{FALSE} return vector of haplotypes.}

\item{plot}{logical. Show plot of haplotypic frequency distribution?}
}
\value{
Frequency table of haplotypes.
}
\description{
Simulate a haplotypic frequency distribution based on
  a specified gamma distribution.
}
\examples{
haps <- simGammaHaps(1000, 15, 1, 2.5)
print(haps)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
