% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gelato.R
\name{gelato}
\alias{gelato}
\alias{gelatoPlot}
\title{GELATo - Group ExcLusion and Assignment Test}
\usage{
gelato(g, unknown.strata, nrep = 1000, min.sample.size = 5, num.cores = 1)

gelatoPlot(gelato.result, unknown, main = NULL)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{unknown.strata}{a character vector listing to assign. Strata must 
occur in \code{g}.}

\item{nrep}{number of permutation replicates for Fst distribution.}

\item{min.sample.size}{minimum number of samples to use to characterize 
knowns. If the known sample size would be smaller than this after drawing 
an equivalent number of unknowns for self-assignment, then the comparison 
is not done.}

\item{num.cores}{number of CPU cores to use. Value is passed to 
\code{\link[parallel]{mclapply}}.}

\item{gelato.result}{the result of a call to \code{gelato}.}

\item{unknown}{the name of an unknown stratum in the \code{x$likelihoods} 
element.}

\item{main}{main label for top of plot.}
}
\value{
A list with the following elements:
\tabular{ll}{
  \code{assign.prob} \tab a data.frame of assignment probabilities.\cr
  \code{likelihoods} \tab a list of likelihoods.\cr
}
}
\description{
Run a GELATo test to evaluate assignment likelihoods of 
  groups of samples.
}
\examples{
data(msats.g)
stratify(msats.g, "fine")

gelato.fine <- gelato(msats.g, unk = "Offshore.South", nrep = 10)

gelatoPlot(gelato.fine, "Offshore.South")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
O'Corry-Crowe, G., W. Lucey, F.I. Archer, and B. Mahoney. 2015. 
  The genetic ecology and population origins of the beluga whales of 
  Yakutat Bay. Marine Fisheries Review.
}

