% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adhoc-core.R
\name{adhoc}
\alias{adhoc}
\title{Execute a single stratum or lamina ad hoc by its name}
\usage{
adhoc(name, prompt = TRUE, silent = FALSE, project_path = NULL)
}
\arguments{
\item{name}{Name of stratum or lamina.}

\item{prompt}{Prompt user for choice if multiple matches found?
Default is \code{TRUE}.}

\item{silent}{Suppress log messages? If \code{FALSE} (the default), log messages
will be printed to the console. If \code{TRUE}, log messages will be suppressed.}

\item{project_path}{A path to strata project folder.}
}
\value{
invisible data frame of execution plan for matched name.
}
\description{
In interactive sessions, \code{adhoc()} will execute the stratum or lamina that
matches the name provided by the user. If multiple matches are found, the
user will be prompted to choose which one to execute.  If no matches are
found, an error will be thrown. \code{project_path} will default to the current
working directory, unless a path is provided by the user.
}
\examples{
\dontrun{
tmp <- fs::dir_create(fs::file_temp())
result <- strata::build_quick_strata_project(tmp, 3, 2)
adhoc("stratum_1")
fs::dir_delete(tmp)
}
}
\seealso{
Other adhoc: 
\code{\link{adhoc_lamina}()},
\code{\link{adhoc_stratum}()}
}
\concept{adhoc}
