% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify.anomalies}
\alias{fortify.anomalies}
\alias{fortify.stranger}
\alias{fortify.singular}
\title{Merge stranger/singular objects to a dataset}
\usage{
\method{fortify}{anomalies}(x, data = NULL, id = NULL,
  colname = "flag_anomaly", ...)

\method{fortify}{stranger}(x, data = NULL, id = NULL, all.x = TRUE,
  all.y = FALSE, ...)

\method{fortify}{singular}(x, data = NULL, id = NULL, all.x = TRUE,
  all.y = FALSE, ...)
}
\arguments{
\item{x}{anomalies objects as generated by a call to \code{\link{get_anomalies}}.}

\item{data}{data to enrich; if NULL (default), we use the data used during computation}

\item{id}{character - name of the id column. No need to specify this if you follow the recommended
process using either first \code{\link{add_id}} or \code{\link{crazyfy}}.}

\item{colname}{character - name of the column to be created for the flag (default: flag_anomaly).}

\item{\dots}{fortify generic parameter -- not used for stranger objects.}

\item{all.x}{merge parameter}

\item{all.y}{merge parameter}
}
\description{
\code{fortify} method for \code{anomalies}, \code{stranger} and \code{singular} objects to enrich data. Usually,
this is invoked on source data. For obvious precautions, this is done on an id column
as managed by the typical workflow (\code{crazyfy}). In case you enrich data without any
specific id, it is just assumed to have those data in the same order than data used in
anomaly detection computations -- this behavior may really needs to unwanted results.
}
