% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{mod}
\alias{mod}
\title{Heligman-Pollard parameter coversion to age-specific probabilites of death.}
\usage{
mod(theta, x)
}
\arguments{
\item{theta}{A vector containing values for the 9 parameters of the adapted Heligman-Pollard model.}

\item{x}{A vector containing the ages at which to calculate the probabilities of death.}
}
\value{
A vector of probabilities of death at ages defined by x.
}
\description{
Calculates the age-specific probabilities of death using the Heligman-Pollard model.
}
\examples{

lifeN <- life.tab(cetaceans)

modSi <- Si.mod(data = cetaceans, rm = 2,
                par = c(0.3159462,  0.1860541, -1.2802880,  1.1733226,  0.0170314))

dataSi <- Si.pred(data = cetaceans, Sout = modSi, rm = 2)

priors <- data.frame(priors.lo = c(0,0.5,0,0,0,0,6,0,1),
                     priors.hi = c(0.1,1,1,0.15,0.15,50,10,0.01,1.5))

q0 <- HP.priors(pri.lo = priors$priors.lo,
                pri.hi = priors$priors.hi,
                theta.dim = 9)

HP.mod(prior = q0, lifeTab = lifeN, rm = 2, K = 10, d = 10, B = 10, CI = 90)

}
\references{
Heligman, L. and Pollard, J.H. (1980). The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
