% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.R
\name{spm}
\alias{spm}
\title{A central function that estimates Stochastic Process Model parameters a from given dataset.}
\usage{
spm(x, model = "discrete", formulas = NULL, start = NULL, tol = NULL,
  stopifbound = FALSE, algorithm = "NLOPT_LN_NELDERMEAD", lb = NULL,
  ub = NULL, maxeval = 100, pinv.tol = 0.01, theta.range = seq(0.01,
  0.2, by = 0.001), verbose = FALSE, gomp = FALSE, ftol_rel = 1e-06)
}
\arguments{
\item{x}{A dataset: is the output from prepare_data(...) function and consists of two separate data tables:
(1) a data table for continuous-time model and (2) a data table for discrete-time model.}

\item{model}{A model type. Choices are: "discrete", "continuous" or "time-dependent".}

\item{formulas}{A list of parameter formulas used in the "time-dependent" model.}

\item{start}{A starting values of coefficients in the "time-dependent" model.}

\item{tol}{A tolerance threshold for matrix inversion (NULL by default).}

\item{stopifbound}{A flag (default=FALSE) if it is set then the optimization stops 
when any of the parametrs achives lower or upper boundary.}

\item{algorithm}{An optimization algorithm used in \code{nloptr} package.
Default: \code{NLOPTR_NL_NELDERMEAD}.}

\item{lb}{Lower boundary, default \code{NULL}.}

\item{ub}{Upper boundary, default \code{NULL}.}

\item{maxeval}{Maximum number of evaluations of optimization algorithm. 
Default 100.}

\item{pinv.tol}{A tolerance threshold for matrix pseudo-inverse. Default: 0.01.}

\item{theta.range}{A user-defined range of the parameter \code{theta} used in 
discrete-time optimization and estimating of starting point for continuous-time optimization.}

\item{verbose}{A verbosing output indicator (FALSE by default).}

\item{gomp}{A flag (FALSE by default). When it is set, then time-dependent exponential form of mu0 and Q are used:
mu0 = mu0*exp(theta*t), Q = Q*exp(theta*t).}

\item{ftol_rel}{Stops when an optimization step (or an estimate of the optimum) changes the objective function. 
Default value 1e-6.}
}
\value{
For "discrete" and "continuous" model types: 
(1) a list of model parameter estimates for the discrete model type described in 
"Life tables with covariates: Dynamic Model for Nonlinear Analysis of Longitudinal Data", 
Akushevich et al, 2005.<DOI:10.1080/08898480590932296>,  and  
(2) a list of model parameter estimates for the continuous model type described in 
"Stochastic model for analysis of longitudinal data on aging and mortality", 
Yashin et al, 2007, Math Biosci.<DOI:10.1016/j.mbs.2006.11.006>.

For the "time-dependent" model (model parameters depend on time): a set of model parameter estimates.
}
\description{
A central function that estimates Stochastic Process Model parameters a from given dataset.
}
\examples{
\dontrun{ 
library(stpm)
data.continuous <- simdata_cont(N=1000)
data.discrete <- simdata_discr(N=1000)
data <- list(data.continuous, data.discrete)
p.discr.model <- spm(data)
p.discr.model
p.cont.model <- spm(data, model="continuous")
p.cont.model
p.td.model <- spm(data, 
model="time-dependent",f=list(at="aa*t+bb", f1t="f1", Qt="Q", ft="f", bt="b", mu0t="mu0"), 
start=list(a=-0.001, bb=0.05, f1=80, Q=2e-8, f=80, b=5, mu0=1e-3))
p.td.model
}
}
\references{
Yashin, A. et al (2007), Stochastic model for analysis of longitudinal data on aging 
and mortality. Mathematical Biosciences, 208(2), 538-551.

Akushevich I., Kulminski A. and Manton K. (2005). Life tables with covariates: Dynamic model 
for Nonlinear Analysis of Longitudinal Data. Mathematical Popu-lation Studies, 12(2), pp.: 51-80.
<DOI: 10.1080/08898480590932296>.

Yashin, A. et al (2007), Health decline, aging and mortality: how are they related? 
Biogerontology, 8(3), 291-302.<DOI:10.1007/s10522-006-9073-3>.
}

