% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storywranglr.R
\name{zipf}
\alias{zipf}
\title{Explore Twitter trends with the Storywrangler zipf API}
\usage{
zipf(date, max = 100, language = "en", ngrams = c(1, 2, 3))
}
\arguments{
\item{date}{The date to query, in either character "YYYY-MM-DD" or Date
format.}

\item{max}{The maximum number of ngrams to return. Defaults to 100.}

\item{language}{The two-letter code of the language to query. Defaults to
"en".}

\item{ngrams}{Integer specifying the type of n-grams to return. Accepts 1, 2,
and 3, and defaults to 1.}
}
\value{
A tibble with the API query and response.
}
\description{
Storywrangler's ngrams API lets you search a large historical database of
Twitter data for daily usage statistics about strings of one, two, and three
words (1-grams, 2-grams, and 3-grams respectively).

This function will query the API for a specific date to return the rank and
frequency data for its top n ngrams. Please note that queries of over 1000
ngrams will take a long time to load.

For more details about Storywrangler, please see:
\itemize{
\item API documentation: \url{https://github.com/janeadams/storywrangler}
\item Academic paper describing uses: \url{https://advances.sciencemag.org/content/7/29/eabe6534.full}
}
}
\examples{
\dontrun{
# Get top English 2-grams for January 6, 2021
 result <- zipf("2021-01-06", ngrams = 2)
}
}
