% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findconst.surv.R
\name{findconst.surv}
\alias{findconst.surv}
\title{Search for Calibration Value (Survival Data)}
\usage{
findconst.surv(n, p0, alpha, type, tau, param = NULL)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p0}{The probability of a toxicity occurring in \code{tau} units of time under the null hypothesis}

\item{alpha}{The nominal type I error/false positive rate for the stopping rule,
under an assumption that the cumulative number of events follows a Poisson process
over the study duration.}

\item{type}{The method used for constructing the stopping rule}

\item{tau}{Length of observation period}

\item{param}{A vector of the extra parameter(s) needed for certain stopping rule methods. For Wang-Tsiatis tests, this is the Delta parameter. For truncated SPRT, this is the targeted alternative toxicity probability p1. For Bayesian Gamma-Poisson model, this is the vector of hyperparameters (shape,rate) for the gamma prior on the toxicity event rate.}
}
\value{
The calibration constant used for subsequent stopping boundary calculation
}
\description{
Internal workhorse function to calculate the calibration constant value that attains level alpha for given method for time-to-event data
}
