% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.rule.R
\name{table.rule}
\alias{table.rule}
\title{Tabulate Stopping Rule}
\usage{
table.rule(rule)
}
\arguments{
\item{rule}{A matrix with two columns: the sample sizes at which sequential testing is performed, and their corresponding rejection boundaries}
}
\value{
A matrix with two columns: the ranges of evaluable patients, and corresponding rejection boundaries for these ranges
}
\description{
Summarize a stopping rule in a condensed tabular format
}
\examples{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity rate of 20\%
poc_rule = calc.rule(ns=1:50,p0=0.20,type="Pocock",alpha=0.10)

# Tabulate stopping boundary
table.rule(poc_rule)
}
